/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.request;

import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.components.RequestXmlDocument;
import com.eviware.soapui.impl.support.components.ResponseXmlDocument;
import com.eviware.soapui.impl.support.panels.AbstractHttpRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.actions.request.CreateEmptyRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.RecreateRequestAction;
import com.eviware.soapui.impl.wsdl.panels.request.actions.WSIValidateRequestAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.views.xml.source.XmlSourceEditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.support.DefaultXmlDocument;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public abstract class AbstractWsdlRequestDesktopPanel<T extends ModelItem, T2 extends WsdlRequest>
extends AbstractHttpRequestDesktopPanel<T, T2>
implements SubmitListener {
    private JButton recreateButton;
    private JButton cloneButton;
    private JButton createEmptyButton;
    private JButton addToMockServiceButton;
    private AbstractAction wsiValidateAction;

    public AbstractWsdlRequestDesktopPanel(T modelItem, T2 request) {
        super(modelItem, request);
    }

    @Override
    protected void init(T2 request) {
        this.recreateButton = AbstractWsdlRequestDesktopPanel.createActionButton(new RecreateRequestAction((WsdlRequest)request), true);
        this.addToMockServiceButton = AbstractWsdlRequestDesktopPanel.createActionButton(SwingActionDelegate.createDelegate("AddRequestToMockServiceAction", request, null, "/addToMockService.gif"), true);
        this.cloneButton = AbstractWsdlRequestDesktopPanel.createActionButton(SwingActionDelegate.createDelegate("CloneRequestAction", request, null, "/clone.png"), true);
        this.createEmptyButton = AbstractWsdlRequestDesktopPanel.createActionButton(new CreateEmptyRequestAction((WsdlRequest)request), true);
        this.wsiValidateAction = SwingActionDelegate.createDelegate(new WSIValidateRequestAction(), request, "alt W");
        this.wsiValidateAction.setEnabled(((WsdlRequest)request).getResponse() != null);
        super.init(request);
    }

    @Override
    protected ModelItemXmlEditor<?, ?> buildResponseEditor() {
        return new WsdlResponseMessageEditor(new ResponseXmlDocument((WsdlRequest)this.getRequest()));
    }

    @Override
    protected ModelItemXmlEditor<?, ?> buildRequestEditor() {
        return new WsdlRequestMessageEditor(new RequestXmlDocument((WsdlRequest)this.getRequest()));
    }

    @Override
    protected void insertButtons(JXToolBar toolbar) {
        toolbar.add(this.addToMockServiceButton);
        toolbar.add(this.recreateButton);
        toolbar.add(this.createEmptyButton);
        toolbar.add(this.cloneButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.recreateButton.setEnabled(enabled);
        this.createEmptyButton.setEnabled(enabled);
        this.cloneButton.setEnabled(enabled);
    }

    @Override
    protected Submit doSubmit() throws Request.SubmitException {
        Analytics.trackAction((String)SoapUIActions.RUN_REQUEST_FROM_REQUEST_EDITOR.getActionName(), (String[])new String[]{"Type", "SOAP"});
        return ((WsdlRequest)this.getRequest()).submit(new WsdlSubmitContext((ModelItem)this.getModelItem()), true);
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        boolean result = super.beforeSubmit(submit, context);
        this.wsiValidateAction.setEnabled(!result);
        return result;
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        super.afterSubmit(submit, context);
        if (!this.isHasClosed()) {
            this.wsiValidateAction.setEnabled(submit.getResponse() != null);
        }
    }

    public class WsdlResponseMessageEditor
    extends AbstractHttpRequestDesktopPanel.AbstractHttpResponseMessageEditor<XmlDocument> {
        public WsdlResponseMessageEditor(XmlDocument document) {
            super((AbstractHttpRequestDesktopPanel)AbstractWsdlRequestDesktopPanel.this, document);
            XmlSourceEditorView editor = this.getSourceEditor();
            JPopupMenu inputPopup = editor.getEditorPopup();
            inputPopup.insert(new JSeparator(), 2);
            inputPopup.insert(AbstractWsdlRequestDesktopPanel.this.wsiValidateAction, 3);
            inputPopup.insert(new JSeparator(), 4);
        }
    }

    public class WsdlRequestMessageEditor
    extends AbstractHttpRequestDesktopPanel.AbstractHttpRequestMessageEditor<XmlDocument> {
        public WsdlRequestMessageEditor(XmlDocument document) {
            super((AbstractHttpRequestDesktopPanel)AbstractWsdlRequestDesktopPanel.this, document);
            XmlSourceEditorView editor = this.getSourceEditor();
            RSyntaxTextArea inputArea = editor.getInputArea();
            inputArea.getInputMap().put(KeyStroke.getKeyStroke("F5"), AbstractWsdlRequestDesktopPanel.this.recreateButton.getAction());
        }
    }

    public static class OneWayResponseMessageEditor
    extends ModelItemXmlEditor<ModelItem, DefaultXmlDocument> {
        public OneWayResponseMessageEditor(ModelItem modelItem) {
            super(new DefaultXmlDocument(), modelItem);
        }
    }
}

