/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.ProjectConfig;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.mock.RestMockAction;
import com.eviware.soapui.impl.rest.mock.RestMockResponse;
import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.panels.project.WSSTabPanel;
import com.eviware.soapui.impl.wsdl.panels.project.WsdlProjectTestSuitesTabPanel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AbstractGroovyEditorModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.ProjectMetrics;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.util.ModelItemIconFactory;
import com.eviware.soapui.security.panels.ProjectSensitiveInformationPanel;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.GroovyEditorComponent;
import com.eviware.soapui.support.components.GroovyEditorInspector;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JFocusableComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.MetricsPanel;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.Document;

public class WsdlProjectDesktopPanel
extends ModelItemDesktopPanel<WsdlProject> {
    protected static final String MOCKRESPONSES_STATISTICS = "WsdlMockResponses";
    protected static final String MOCKOPERATIONS_STATISTICS = "WsdlMockOperations";
    protected static final String MOCKSERVICES_STATISTICS = "WsdlMockServices";
    protected static final String REST_MOCKRESPONSES_STATISTICS = "RestMockResponses";
    protected static final String REST_MOCKACTIONS_STATISTICS = "RestMockActions";
    protected static final String REST_MOCKSERVICES_STATISTICS = "RestMockServices";
    protected static final String LOADTESTS_STATISTICS = "LoadTests";
    protected static final String ASSERTIONS_STATISTICS = "Assertions";
    protected static final String TESTSTEPS_STATISTICS = "TestSteps";
    protected static final String TESTCASES_STATISTICS = "TestCases";
    protected static final String TESTSUITES_STATISTICS = "TestSuites";
    private PropertyHolderTable propertiesTable;
    private JUndoableTextArea descriptionArea;
    private InternalTreeModelListener treeModelListener;
    private Set<String> interfaceNameSet = new HashSet<String>();
    private WSSTabPanel wssTabPanel;
    protected MetricsPanel metrics;
    private GroovyEditorComponent loadScriptGroovyEditor;
    private GroovyEditorComponent saveScriptGroovyEditor;
    private JInspectorPanel inspectorPanel;
    private WsdlProjectTestSuitesTabPanel testSuitesPanel;
    private ProjectSensitiveInformationPanel sensitiveInfoPanel;

    public WsdlProjectDesktopPanel(WsdlProject modelItem) {
        super(modelItem);
        this.add(this.buildTabbedPane(), "Center");
        this.setPreferredSize(new Dimension(600, 600));
    }

    private Component buildTabbedPane() {
        JTabbedPane mainTabs = new JTabbedPane();
        this.addTabs(mainTabs);
        return UISupport.createTabPanel(mainTabs, true);
    }

    protected void addTabs(JTabbedPane mainTabs) {
        mainTabs.addTab("Overview", null, this.buildOverviewTab(), "Shows General Project information and metrics");
        this.testSuitesPanel = this.buildTestSuitesTab();
        mainTabs.addTab(TESTSUITES_STATISTICS, null, this.testSuitesPanel, "Shows and runs all TestSuites in project");
        mainTabs.addTab("WS-Security Configurations", null, this.buildWSSTab(), "Manages Security-related configurations");
        mainTabs.addTab("Security Scan Defaults", null, this.buildSecConfigTab(), "Manages Security related configurations");
    }

    private Component buildSecConfigTab() {
        this.sensitiveInfoPanel = new ProjectSensitiveInformationPanel((ProjectConfig)((WsdlProject)this.getModelItem()).getConfig());
        return this.sensitiveInfoPanel.getMainPanel();
    }

    public WsdlProjectTestSuitesTabPanel getTestSuitesPanel() {
        return this.testSuitesPanel;
    }

    protected WsdlProjectTestSuitesTabPanel buildTestSuitesTab() {
        return new WsdlProjectTestSuitesTabPanel((WsdlProject)this.getModelItem());
    }

    protected Component buildWSSTab() {
        this.wssTabPanel = new WSSTabPanel(((WsdlProject)this.getModelItem()).getWssContainer());
        return this.wssTabPanel;
    }

    protected Component buildOverviewTab() {
        this.inspectorPanel = JInspectorPanelFactory.build(this.buildProjectOverview());
        this.addOverviewInspectors(this.inspectorPanel);
        this.inspectorPanel.setCurrentInspector("Properties");
        if (StringUtils.hasContent(((WsdlProject)this.getModelItem()).getDescription()) && ((WsdlProject)this.getModelItem()).getSettings().getBoolean(UISettings.SHOW_DESCRIPTIONS)) {
            this.inspectorPanel.setCurrentInspector("Description");
        }
        this.treeModelListener = new InternalTreeModelListener();
        SoapUI.getNavigator().getMainTree().getModel().addTreeModelListener(this.treeModelListener);
        this.updateStatistics();
        return this.inspectorPanel.getComponent();
    }

    protected void addOverviewInspectors(JInspectorPanel inspectorPanel) {
        inspectorPanel.addInspector(new JFocusableComponentInspector<JPanel>(this.buildDescriptionPanel(), this.descriptionArea, "Description", "Project description", true));
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildPropertiesPanel(), "Properties", "Project level properties", true));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildLoadScriptPanel(), "Load Script", "Script to run after loading the project"));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildSaveScriptPanel(), "Save Script", "Script to run before saving the project"));
    }

    private void updateStatistics() {
        ProjectMetrics projectMetrics = new ProjectMetrics((Project)this.getModelItem());
        this.metrics.setMetric("File Path", ((WsdlProject)this.getModelItem()).getPath());
        HashSet<String> newNames = new HashSet<String>();
        boolean rebuilt = false;
        for (Interface iface : ((WsdlProject)this.getModelItem()).getInterfaceList()) {
            if (!this.metrics.hasMetric(iface.getName())) {
                MetricsPanel.MetricsSection section = this.metrics.getSection("Interface Summary");
                this.buildInterfaceSummary(section.clear());
                rebuilt = true;
                break;
            }
            newNames.add(iface.getName());
            this.interfaceNameSet.remove(iface.getName());
        }
        if (!rebuilt) {
            if (!this.interfaceNameSet.isEmpty()) {
                MetricsPanel.MetricsSection section = this.metrics.getSection("Interface Summary");
                this.buildInterfaceSummary(section.clear());
            }
            this.interfaceNameSet = newNames;
        }
        this.metrics.setMetric(TESTSUITES_STATISTICS, ((WsdlProject)this.getModelItem()).getTestSuiteCount());
        this.metrics.setMetric(TESTCASES_STATISTICS, projectMetrics.getTestCaseCount());
        this.metrics.setMetric(TESTSTEPS_STATISTICS, projectMetrics.getTestStepCount());
        this.metrics.setMetric(ASSERTIONS_STATISTICS, projectMetrics.getAssertionCount());
        this.metrics.setMetric(LOADTESTS_STATISTICS, projectMetrics.getLoadTestCount());
        this.metrics.setMetric(MOCKSERVICES_STATISTICS, ((WsdlProject)this.getModelItem()).getMockServiceCount());
        this.metrics.setMetric(MOCKOPERATIONS_STATISTICS, projectMetrics.getMockOperationCount());
        this.metrics.setMetric(MOCKRESPONSES_STATISTICS, projectMetrics.getMockResponseCount());
        this.metrics.setMetric(REST_MOCKSERVICES_STATISTICS, ((WsdlProject)this.getModelItem()).getRestMockServiceCount());
        this.metrics.setMetric(REST_MOCKACTIONS_STATISTICS, projectMetrics.getRestMockActionCount());
        this.metrics.setMetric(REST_MOCKRESPONSES_STATISTICS, projectMetrics.getRestMockResponseCount());
    }

    private JComponent buildProjectOverview() {
        this.metrics = new MetricsPanel();
        JXToolBar toolbar = this.buildOverviewToolbar();
        this.metrics.add((Component)toolbar, "North");
        MetricsPanel.MetricsSection section = this.metrics.addSection("Project Summary");
        section.addMetric(ModelItemIconFactory.getIcon(Project.class), "File Path", MetricsPanel.MetricType.URL);
        section.finish();
        section = this.metrics.addSection("Interface Summary");
        this.buildInterfaceSummary(section);
        section = this.metrics.addSection("Test Summary");
        section.addMetric(ModelItemIconFactory.getIcon(TestSuite.class), TESTSUITES_STATISTICS);
        section.addMetric(ModelItemIconFactory.getIcon(TestCase.class), TESTCASES_STATISTICS);
        section.addMetric(ModelItemIconFactory.getIcon(TestStep.class), TESTSTEPS_STATISTICS);
        section.addMetric(ModelItemIconFactory.getIcon(TestAssertion.class), ASSERTIONS_STATISTICS);
        section.addMetric(ModelItemIconFactory.getIcon(LoadTest.class), LOADTESTS_STATISTICS);
        section.finish();
        section = this.metrics.addSection("SOAP Mock Summary");
        section.addMetric(ModelItemIconFactory.getIcon(MockService.class), MOCKSERVICES_STATISTICS);
        section.addMetric(ModelItemIconFactory.getIcon(MockOperation.class), MOCKOPERATIONS_STATISTICS);
        section.addMetric(ModelItemIconFactory.getIcon(MockResponse.class), MOCKRESPONSES_STATISTICS);
        section.finish();
        section = this.metrics.addSection("REST Mock Summary");
        section.addMetric(ModelItemIconFactory.getIcon(RestMockService.class), REST_MOCKSERVICES_STATISTICS);
        section.addMetric(ModelItemIconFactory.getIcon(RestMockAction.class), REST_MOCKACTIONS_STATISTICS);
        section.addMetric(ModelItemIconFactory.getIcon(RestMockResponse.class), REST_MOCKRESPONSES_STATISTICS);
        section.finish();
        return new JScrollPane(this.metrics);
    }

    protected JXToolBar buildOverviewToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("/Working-with-Projects/working-with-soapui-projects.html")));
        return toolbar;
    }

    protected void buildInterfaceSummary(MetricsPanel.MetricsSection section) {
        this.interfaceNameSet.clear();
        for (Interface ic : ((WsdlProject)this.getModelItem()).getInterfaceList()) {
            AbstractInterface iface;
            if (ic instanceof WsdlInterface) {
                iface = (WsdlInterface)ic;
                section.addMetric(iface.getIcon(), iface.getName(), MetricsPanel.MetricType.URL).set(((WsdlInterface)iface).getDefinition());
            } else if (ic instanceof RestService) {
                iface = (RestService)ic;
                section.addMetric(iface.getIcon(), iface.getName(), MetricsPanel.MetricType.URL).set(((RestService)iface).getWadlUrl());
            }
            this.interfaceNameSet.add(ic.getName());
        }
        section.finish();
    }

    private JPanel buildDescriptionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.descriptionArea = new JUndoableTextArea(((WsdlProject)this.getModelItem()).getDescription());
        this.descriptionArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                ((WsdlProject)WsdlProjectDesktopPanel.this.getModelItem()).setDescription(WsdlProjectDesktopPanel.this.descriptionArea.getText());
            }
        });
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add((Component)new JScrollPane(this.descriptionArea), "Center");
        UISupport.addTitledBorder(panel, "Project Description");
        return panel;
    }

    protected GroovyEditorComponent buildLoadScriptPanel() {
        this.loadScriptGroovyEditor = new GroovyEditorComponent(new LoadScriptGroovyEditorModel(), null);
        return this.loadScriptGroovyEditor;
    }

    protected GroovyEditorComponent buildSaveScriptPanel() {
        this.saveScriptGroovyEditor = new GroovyEditorComponent(new SaveScriptGroovyEditorModel(), null);
        return this.saveScriptGroovyEditor;
    }

    private JComponent buildPropertiesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.propertiesTable = new PropertyHolderTable((TestPropertyHolder)this.getModelItem());
        if (this.getModelItem() instanceof WsdlProject) {
            ((WsdlProject)this.getModelItem()).addProjectListener(this.propertiesTable.getProjectListener());
        }
        panel.add((Component)this.propertiesTable, "Center");
        return panel;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem();
    }

    @Override
    public boolean onClose(boolean canCancel) {
        this.propertiesTable.release();
        this.loadScriptGroovyEditor.getEditor().release();
        this.saveScriptGroovyEditor.getEditor().release();
        SoapUI.getNavigator().getMainTree().getModel().removeTreeModelListener(this.treeModelListener);
        this.wssTabPanel.release();
        this.sensitiveInfoPanel.release();
        this.inspectorPanel.release();
        this.testSuitesPanel.release();
        return this.release();
    }

    private class SaveScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public SaveScriptGroovyEditorModel() {
            super(new String[]{"log", "project"}, (ModelItem)WsdlProjectDesktopPanel.this.getModelItem(), "Save");
        }

        @Override
        public String getScript() {
            return ((WsdlProject)WsdlProjectDesktopPanel.this.getModelItem()).getBeforeSaveScript();
        }

        @Override
        public void setScript(String text) {
            ((WsdlProject)WsdlProjectDesktopPanel.this.getModelItem()).setBeforeSaveScript(text);
        }

        @Override
        public Action getRunAction() {
            return new BeforeSaveScriptRunAction();
        }

        private final class BeforeSaveScriptRunAction
        extends AbstractAction {
            public BeforeSaveScriptRunAction() {
                this.putValue("SmallIcon", UISupport.createImageIcon("/run.png"));
                this.putValue("ShortDescription", "Runs this script");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ((WsdlProject)WsdlProjectDesktopPanel.this.getModelItem()).runBeforeSaveScript();
                }
                catch (Exception e1) {
                    UISupport.showErrorMessage(e1);
                }
            }
        }
    }

    private class LoadScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public LoadScriptGroovyEditorModel() {
            super(new String[]{"log", "project"}, (ModelItem)WsdlProjectDesktopPanel.this.getModelItem(), "Load");
        }

        @Override
        public String getScript() {
            return ((WsdlProject)WsdlProjectDesktopPanel.this.getModelItem()).getAfterLoadScript();
        }

        @Override
        public void setScript(String text) {
            ((WsdlProject)WsdlProjectDesktopPanel.this.getModelItem()).setAfterLoadScript(text);
        }

        @Override
        public Action getRunAction() {
            return new AfterLoadScriptRunAction();
        }

        private final class AfterLoadScriptRunAction
        extends AbstractAction {
            public AfterLoadScriptRunAction() {
                this.putValue("SmallIcon", UISupport.createImageIcon("/run.png"));
                this.putValue("ShortDescription", "Runs this script");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ((WsdlProject)WsdlProjectDesktopPanel.this.getModelItem()).runAfterLoadScript();
                }
                catch (Exception e1) {
                    UISupport.showErrorMessage(e1);
                }
            }
        }
    }

    private final class InternalTreeModelListener
    implements TreeModelListener {
        private InternalTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            WsdlProjectDesktopPanel.this.updateStatistics();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            WsdlProjectDesktopPanel.this.updateStatistics();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            WsdlProjectDesktopPanel.this.updateStatistics();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            WsdlProjectDesktopPanel.this.updateStatistics();
        }
    }
}

