/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.testcase.JTestRunLog;
import com.eviware.soapui.impl.wsdl.panels.testcase.TestRunLogTestRunListener;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestSuiteRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestSuiteRunContext;
import com.eviware.soapui.model.testsuite.TestSuiteRunListener;
import com.eviware.soapui.model.testsuite.TestSuiteRunner;
import com.eviware.soapui.support.DateUtil;
import java.util.Date;

public class TestRunLogTestSuiteRunListener
extends TestRunLogTestRunListener
implements TestSuiteRunListener {
    public TestRunLogTestSuiteRunListener(JTestRunLog runLog, boolean clearOnRun) {
        super(runLog, clearOnRun);
    }

    @Override
    public void beforeRun(TestSuiteRunner testRunner, TestSuiteRunContext runContext) {
        if (SoapUI.getTestMonitor().hasRunningLoadTest(testRunner.getTestSuite())) {
            return;
        }
        if (this.clearOnRun) {
            this.runLog.clear();
        }
        String testSuiteName = testRunner.getTestRunnable().getName();
        this.runLog.addBoldText("TestSuite [" + testSuiteName + "] started at " + DateUtil.formatFull(new Date()));
        this.runLog.setStepIndex(0);
    }

    @Override
    public void afterRun(TestSuiteRunner testRunner, TestSuiteRunContext runContext) {
        if (SoapUI.getTestMonitor().hasRunningLoadTest(testRunner.getTestSuite())) {
            return;
        }
        WsdlTestSuiteRunner wsdlRunner = (WsdlTestSuiteRunner)testRunner;
        String testSuiteName = testRunner.getTestRunnable().getName();
        if (testRunner.getStatus() == TestRunner.Status.CANCELED) {
            this.runLog.addText("TestSuite [" + testSuiteName + "] canceled [" + testRunner.getReason() + "], time taken = " + wsdlRunner.getTimeTaken());
        } else if (testRunner.getStatus() == TestRunner.Status.FAILED) {
            String msg = wsdlRunner.getReason();
            if (wsdlRunner.getError() != null) {
                if (msg != null) {
                    msg = msg + ":";
                }
                msg = msg + wsdlRunner.getError();
            }
            this.runLog.addText("TestSuite [" + testSuiteName + "] failed [" + msg + "], time taken = " + wsdlRunner.getTimeTaken());
        } else {
            this.runLog.addText("TestSuite [" + testSuiteName + "] finished with status [" + (Object)((Object)testRunner.getStatus()) + "], time taken = " + wsdlRunner.getTimeTaken());
        }
    }

    @Override
    public void beforeTestCase(TestSuiteRunner testRunner, TestSuiteRunContext runContext, TestCase testCase) {
        if (SoapUI.getTestMonitor().hasRunningLoadTest(testRunner.getTestSuite())) {
            return;
        }
        testCase.addTestRunListener(this);
    }

    @Override
    public void afterTestCase(TestSuiteRunner testRunner, TestSuiteRunContext runContext, TestCaseRunner testCaseRunner) {
        testCaseRunner.getTestCase().removeTestRunListener(this);
    }
}

