/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.strategy;

import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.AbstractLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyFactory;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.swing.ComponentBag;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

public class VarianceLoadStrategy
extends AbstractLoadStrategy {
    private static final Logger log = Logger.getLogger(VarianceLoadStrategy.class);
    public static final String STRATEGY_TYPE = "Variance";
    private static final String INTERVAL_ELEMENT = "interval";
    private static final String VARIANCE_ELEMENT = "variance";
    private static final int DEFAULT_INTERVAL = 60000;
    private static final float DEFAULT_VARIANCE = 0.5f;
    private JPanel configPanel;
    private long interval = 60000L;
    private float variance = 0.5f;
    private JTextField intervalField;
    private JTextField varianceField;
    private JLabel infoLabel;
    private long baseThreadCount;
    private long startTime;
    private ComponentBag stateDependantComponents = new ComponentBag();

    public VarianceLoadStrategy(WsdlLoadTest loadTest) {
        super(STRATEGY_TYPE, loadTest);
        this.interval = 60000L;
        this.variance = 0.5f;
    }

    public VarianceLoadStrategy(XmlObject config, WsdlLoadTest loadTest) {
        super(STRATEGY_TYPE, loadTest);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(config);
        this.interval = reader.readLong(INTERVAL_ELEMENT, 60000);
        this.variance = reader.readFloat(VARIANCE_ELEMENT, 0.5f);
    }

    @Override
    public JComponent getConfigurationPanel() {
        if (this.configPanel == null) {
            ButtonBarBuilder builder = new ButtonBarBuilder();
            this.intervalField = new JTextField(4);
            UISupport.setPreferredHeight(this.intervalField, 18);
            this.intervalField.setHorizontalAlignment(4);
            this.intervalField.setText(String.valueOf(this.interval / 1000L));
            this.intervalField.setToolTipText("Sets the interval between variances in seconds");
            this.intervalField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

                @Override
                public void update(Document doc) {
                    try {
                        VarianceLoadStrategy.this.interval = Long.parseLong(VarianceLoadStrategy.this.intervalField.getText()) * 1000L;
                        VarianceLoadStrategy.this.notifyConfigurationChanged();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            builder.addFixed((JComponent)new JLabel("Interval"));
            builder.addRelatedGap();
            builder.addFixed((JComponent)this.intervalField);
            builder.addRelatedGap();
            this.varianceField = new JTextField(3);
            UISupport.setPreferredHeight(this.varianceField, 18);
            this.varianceField.setHorizontalAlignment(4);
            this.varianceField.setText(String.valueOf(this.variance));
            this.varianceField.setToolTipText("Specifies the relative magnitude of a variance");
            this.varianceField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

                @Override
                public void update(Document doc) {
                    try {
                        VarianceLoadStrategy.this.variance = Float.parseFloat(VarianceLoadStrategy.this.varianceField.getText());
                        VarianceLoadStrategy.this.notifyConfigurationChanged();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            builder.addFixed((JComponent)new JLabel(STRATEGY_TYPE));
            builder.addRelatedGap();
            builder.addFixed((JComponent)this.varianceField);
            builder.addRelatedGap();
            this.infoLabel = new JLabel();
            builder.addFixed((JComponent)this.infoLabel);
            this.configPanel = builder.getPanel();
            this.stateDependantComponents.add(this.intervalField);
            this.stateDependantComponents.add(this.varianceField);
        }
        return this.configPanel;
    }

    @Override
    public XmlObject getConfig() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(INTERVAL_ELEMENT, this.interval);
        builder.add(VARIANCE_ELEMENT, this.variance);
        return builder.finish();
    }

    @Override
    public void beforeLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
        super.beforeLoadTest(loadTestRunner, context);
        this.baseThreadCount = ((WsdlLoadTest)loadTestRunner.getLoadTest()).getThreadCount();
        this.startTime = System.currentTimeMillis();
        this.stateDependantComponents.setEnabled(false);
    }

    @Override
    public void recalculate(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
        WsdlLoadTest wsdlLoadTest;
        double timePassed = (System.currentTimeMillis() - this.startTime) % this.interval;
        float threadCount = this.baseThreadCount;
        double quarter = (double)this.interval / 4.0;
        threadCount = timePassed < quarter ? (threadCount += (float)((int)Math.round(timePassed / quarter * (double)this.variance * (double)threadCount))) : (timePassed < quarter * 2.0 ? (threadCount += (float)((int)Math.round((1.0 - timePassed % quarter / quarter) * (double)this.variance * (double)threadCount))) : (timePassed < quarter * 3.0 ? (threadCount -= (float)((int)Math.round(timePassed % quarter / quarter * (double)this.variance * (double)threadCount))) : (threadCount -= (float)((int)Math.round((1.0 - timePassed % quarter / quarter) * (double)this.variance * (double)threadCount)))));
        if (threadCount < 1.0f) {
            threadCount = 1.0f;
        }
        if ((wsdlLoadTest = (WsdlLoadTest)loadTestRunner.getLoadTest()).getThreadCount() != (long)((int)threadCount)) {
            log.debug((Object)("Changing threadcount to " + threadCount));
            wsdlLoadTest.setThreadCount((int)threadCount);
        }
    }

    @Override
    public void afterLoadTest(LoadTestRunner testRunner, LoadTestRunContext context) {
        WsdlLoadTest wsdlLoadTest = (WsdlLoadTest)testRunner.getLoadTest();
        wsdlLoadTest.setThreadCount(this.baseThreadCount);
        this.stateDependantComponents.setEnabled(true);
    }

    @Override
    public boolean allowThreadCountChangeDuringRun() {
        return false;
    }

    public long getInterval() {
        return this.interval;
    }

    public float getVariance() {
        return this.variance;
    }

    public static class Factory
    implements LoadStrategyFactory {
        @Override
        public String getType() {
            return VarianceLoadStrategy.STRATEGY_TYPE;
        }

        @Override
        public LoadStrategy build(XmlObject config, WsdlLoadTest loadTest) {
            return new VarianceLoadStrategy(config, loadTest);
        }

        @Override
        public LoadStrategy create(WsdlLoadTest loadTest) {
            return new VarianceLoadStrategy(loadTest);
        }
    }
}

