/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.project.SaveStatus;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.io.IOException;

public class CloseProjectAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "CloseProjectAction";

    public CloseProjectAction() {
        super("Close Project", "Closes this project");
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        if (project.isRemote()) {
            if (UISupport.confirm("Close remote project? (changes will be lost)", this.getName())) {
                project.getWorkspace().closeProject(project);
            }
        } else {
            Boolean saveProject = UISupport.confirmOrCancel("Save project [" + project.getName() + "] before closing?", "Close Project");
            if (saveProject == null) {
                return;
            }
            try {
                SaveStatus status;
                if (saveProject.booleanValue() && ((status = project.save()) == SaveStatus.CANCELLED || status == SaveStatus.FAILED)) {
                    return;
                }
                project.getWorkspace().closeProject(project);
            }
            catch (IOException e) {
                UISupport.showErrorMessage(e);
            }
        }
    }
}

