/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockoperation;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;

public class ChangeMockOperationAction
extends AbstractSoapUIAction<WsdlMockOperation> {
    private XFormDialog dialog;
    private WsdlMockOperation testStep;

    public ChangeMockOperationAction() {
        super("Change Operation", "Changes the Interface Operation for this MockOperation");
    }

    @Override
    public void perform(WsdlMockOperation target, Object param) {
        this.testStep = target;
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.getFormField("Interface").addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    WsdlProject project = ChangeMockOperationAction.this.testStep.getMockService().getProject();
                    ChangeMockOperationAction.this.dialog.setOptions("Operation", ModelSupport.getNames(project.getInterfaceByName(newValue).getOperationList()));
                    WsdlOperation operation = ChangeMockOperationAction.this.testStep.getOperation();
                    ChangeMockOperationAction.this.dialog.setValue("Operation", operation == null ? "" : operation.getName());
                }
            });
            this.dialog.getFormField("Recreate Responses").addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    boolean enabled = Boolean.parseBoolean(newValue);
                    ChangeMockOperationAction.this.dialog.getFormField("Create Optional").setEnabled(enabled);
                    ChangeMockOperationAction.this.dialog.getFormField("Keep Existing").setEnabled(enabled);
                }
            });
            this.dialog.getFormField("Create Optional").setEnabled(false);
            this.dialog.getFormField("Keep Existing").setEnabled(false);
        }
        WsdlOperation operation = this.testStep.getOperation();
        WsdlProject project = this.testStep.getMockService().getProject();
        Object[] interfaceNames = ModelSupport.getNames(project.getInterfaceList(), new ModelSupport.InterfaceTypeFilter("wsdl"));
        this.dialog.setOptions("Interface", interfaceNames);
        this.dialog.setValue("Interface", (String)(operation == null ? interfaceNames[0] : operation.getInterface().getName()));
        this.dialog.setOptions("Operation", ModelSupport.getNames(project.getInterfaceByName(this.dialog.getValue("Interface")).getOperationList()));
        this.dialog.setValue("Operation", operation == null ? null : operation.getName());
        this.dialog.setValue("Name", target.getName());
        if (this.dialog.show()) {
            String ifaceName = this.dialog.getValue("Interface");
            String operationName = this.dialog.getValue("Operation");
            WsdlInterface iface = (WsdlInterface)project.getInterfaceByName(ifaceName);
            operation = iface.getOperationByName(operationName);
            target.setOperation(operation);
            String name = this.dialog.getValue("Name").trim();
            if (name.length() > 0 && !target.getName().equals(name)) {
                target.setName(name);
            }
            if (this.dialog.getBooleanValue("Recreate Responses")) {
                String req = operation.createResponse(this.dialog.getBooleanValue("Create Optional"));
                if (req == null) {
                    UISupport.showErrorMessage("Response creation failed");
                } else {
                    for (int c = 0; c < target.getMockResponseCount(); ++c) {
                        String msg = req;
                        WsdlMockResponse mockResponse = (WsdlMockResponse)target.getMockResponseAt(c);
                        if (this.dialog.getBooleanValue("Keep Existing")) {
                            msg = XmlUtils.transferValues(mockResponse.getResponseContent(), req);
                        }
                        mockResponse.setResponseContent(msg);
                    }
                }
            }
        }
    }

    @AForm(description="Specify Interface/Operation for MockOperation", name="Change Operation", helpUrl="/soap-mocking/working-with-mockservices.html", icon="/applications-system.png")
    protected static interface Form {
        @AField(name="Name", description="The Name of the MockOperation", type=AField.AFieldType.STRING)
        public static final String NAME = "Name";
        @AField(name="Interface", description="The MockOperations Interface", type=AField.AFieldType.ENUMERATION)
        public static final String INTERFACE = "Interface";
        @AField(name="Operation", description="The MockOperations Operation", type=AField.AFieldType.ENUMERATION)
        public static final String OPERATION = "Operation";
        @AField(name="Recreate Responses", description="Recreates all MockResponses content from the new Operations Definition", type=AField.AFieldType.BOOLEAN)
        public static final String RECREATE_REQUEST = "Recreate Responses";
        @AField(name="Create Optional", description="Creates optional content when recreating the response", type=AField.AFieldType.BOOLEAN)
        public static final String CREATE_OPTIONAL = "Create Optional";
        @AField(name="Keep Existing", description="Tries to keep existing values when recreating the response", type=AField.AFieldType.BOOLEAN)
        public static final String KEEP_EXISTING = "Keep Existing";
    }
}

