/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.DocumentContent;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.support.editor.EditorDocument;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;

public class ResponseXmlDocument
extends AbstractXmlDocument
implements PropertyChangeListener {
    private final WsdlRequest request;
    private boolean settingResponse;

    public ResponseXmlDocument(WsdlRequest request) {
        this.request = request;
        request.addPropertyChangeListener(this);
    }

    @Override
    @Nonnull
    public DocumentContent getDocumentContent(EditorDocument.Format format) {
        WsdlResponse response = this.request.getResponse();
        return new DocumentContent(response == null ? null : response.getContentType(), response == null ? null : response.getContentAsString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDocumentContent(DocumentContent documentContent) {
        WsdlResponse response = this.request.getResponse();
        if (response != null) {
            try {
                this.settingResponse = true;
                response.setResponseContent(documentContent.getContentAsString());
                this.fireContentChanged();
            }
            finally {
                this.settingResponse = false;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.settingResponse) {
            return;
        }
        if (evt.getPropertyName().equals(WsdlRequest.RESPONSE_PROPERTY) || evt.getPropertyName().equals(WsdlRequest.RESPONSE_CONTENT_PROPERTY)) {
            this.fireContentChanged();
        }
    }

    @Override
    public SchemaTypeSystem getTypeSystem() {
        WsdlInterface iface = this.request.getOperation().getInterface();
        WsdlContext wsdlContext = iface.getWsdlContext();
        try {
            return wsdlContext.getSchemaTypeSystem();
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
            return XmlBeans.getBuiltinTypeSystem();
        }
    }

    @Override
    public void release() {
        this.request.removePropertyChangeListener(this);
    }
}

