/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.support;

import com.eviware.soapui.config.RestRequestConfig;
import com.eviware.soapui.config.StringListConfig;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.actions.support.NewRestResourceActionBase;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.types.StringToStringMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;

public class RestRequestParamsPropertyHolder
implements RestParamsPropertyHolder,
TestPropertyListener {
    private StringToStringMap values;
    private RestParamsPropertyHolder methodParams;
    private List<String> sortedPropertyNames;
    private RestRequest restRequest;
    private Set<TestPropertyListener> listeners = new HashSet<TestPropertyListener>();
    private Map<RestParamProperty, InternalRestParamProperty> wrappers = new HashMap<RestParamProperty, InternalRestParamProperty>();
    private String parameterBeingMoved;

    public RestRequestParamsPropertyHolder(RestParamsPropertyHolder methodParams, RestRequest restRequest, StringToStringMap values) {
        this.methodParams = methodParams;
        this.restRequest = restRequest;
        this.buildPropertyNameList();
        this.values = values;
        methodParams.addTestPropertyListener(this);
    }

    private void buildPropertyNameList() {
        ArrayList<String> propertyNames;
        RestRequestConfig requestConfig = (RestRequestConfig)this.restRequest.getConfig();
        ArrayList<String> methodParamNames = new ArrayList<String>(Arrays.asList(this.methodParams.getPropertyNames()));
        if (requestConfig.isSetParameterOrder()) {
            propertyNames = new ArrayList<String>(requestConfig.getParameterOrder().getEntryList());
            propertyNames.retainAll(methodParamNames);
            methodParamNames.removeAll(propertyNames);
            propertyNames.addAll(methodParamNames);
        } else {
            propertyNames = new ArrayList<String>(methodParamNames);
        }
        this.sortedPropertyNames = propertyNames;
    }

    public void reset(RestParamsPropertyHolder methodParams, StringToStringMap values) {
        this.methodParams = methodParams;
        this.values = values;
        this.clearWrappers();
    }

    private void clearWrappers() {
        for (InternalRestParamProperty property : this.wrappers.values()) {
            property.release();
        }
        this.wrappers.clear();
    }

    @Override
    public RestParamProperty addProperty(String name) {
        RestParamProperty property = this.methodParams.addProperty(name);
        this.setParameterLocation(property, NewRestResourceActionBase.ParamLocation.RESOURCE);
        return this.getWrapper(this.methodParams.getProperty(name));
    }

    @Override
    public void addParameter(RestParamProperty prop) {
        this.methodParams.addParameter(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameterLocation(RestParamProperty parameter, NewRestResourceActionBase.ParamLocation newLocation) {
        if (newLocation == parameter.getParamLocation()) {
            return;
        }
        this.parameterBeingMoved = parameter.getName();
        try {
            RestParamProperty newParameter;
            RestParamsPropertyHolder.ParameterStyle parameterStyle = parameter.getStyle();
            String parameterValue = parameter.getValue();
            QName type = parameter.getType();
            String[] options = parameter.getOptions();
            boolean required = parameter.getRequired();
            String description = parameter.getDescription();
            boolean disableURLEncoding = parameter.isDisableUrlEncoding();
            ArrayList<String> copyOfSortedPropertyNames = new ArrayList<String>(this.sortedPropertyNames);
            if (newLocation == NewRestResourceActionBase.ParamLocation.METHOD) {
                this.restRequest.getResource().removeProperty(this.parameterBeingMoved);
                newParameter = this.restRequest.getRestMethod().addProperty(this.parameterBeingMoved);
            } else {
                this.restRequest.getRestMethod().removeProperty(this.parameterBeingMoved);
                newParameter = this.restRequest.getResource().addProperty(this.parameterBeingMoved);
            }
            newParameter.setType(type);
            newParameter.setStyle(parameterStyle);
            newParameter.setValue(parameterValue);
            newParameter.setDefaultValue(parameterValue);
            newParameter.setOptions(options);
            newParameter.setRequired(required);
            newParameter.setDescription(description);
            newParameter.setDisableUrlEncoding(disableURLEncoding);
            this.restRequest.getProperty(this.parameterBeingMoved).setValue(parameterValue);
            this.sortedPropertyNames = copyOfSortedPropertyNames;
            this.firePropertyRemoved(this.parameterBeingMoved);
            this.firePropertyAdded(this.parameterBeingMoved);
        }
        finally {
            this.parameterBeingMoved = null;
        }
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void clear() {
        for (String key : this.getPropertyNames()) {
            String oldValue = this.getPropertyValue(key);
            this.values.put(key, "");
            this.firePropertyValueChanged(key, oldValue, "");
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.methodParams.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value) || this.methodParams.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, TestProperty>> entrySet() {
        Set<Map.Entry<String, TestProperty>> entrySet = this.methodParams.entrySet();
        for (Map.Entry entry : entrySet) {
            entry.setValue(this.getWrapper((RestParamProperty)entry.getValue()));
        }
        return entrySet;
    }

    @Override
    public RestParamProperty get(Object key) {
        if (!this.methodParams.containsKey(key)) {
            return null;
        }
        return this.getWrapper(this.methodParams.get(key));
    }

    @Override
    public ModelItem getModelItem() {
        return this.restRequest;
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        Map<String, TestProperty> map = this.methodParams.getProperties();
        for (Map.Entry<String, TestProperty> entry : map.entrySet()) {
            map.put(entry.getKey(), this.getWrapper((RestParamProperty)entry.getValue()));
        }
        return map;
    }

    @Override
    public String getPropertiesLabel() {
        return this.methodParams.getPropertiesLabel();
    }

    @Override
    public RestParamProperty getProperty(String name) {
        if (!this.methodParams.hasProperty(name)) {
            return null;
        }
        return this.getWrapper(this.methodParams.getProperty(name));
    }

    @Override
    public RestParamProperty getPropertyAt(int index) {
        if (this.methodParams.getPropertyCount() <= index) {
            return null;
        }
        this.buildPropertyNameList();
        String propertyName = this.sortedPropertyNames.get(index);
        RestParamProperty propertyToWrap = this.methodParams.getProperty(propertyName);
        return this.getWrapper(propertyToWrap);
    }

    @Override
    public int getPropertyCount() {
        return this.methodParams.getPropertyCount();
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        return this.methodParams.getPropertyExpansions();
    }

    @Override
    public int getPropertyIndex(String name) {
        return this.sortedPropertyNames.indexOf(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.sortedPropertyNames.toArray(new String[this.sortedPropertyNames.size()]);
    }

    @Override
    public String getPropertyValue(String name) {
        return this.values.containsKey(name) ? (String)this.values.get(name) : this.methodParams.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.methodParams.hasProperty(name);
    }

    @Override
    public boolean isEmpty() {
        return this.methodParams.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new LinkedHashSet<String>(this.sortedPropertyNames);
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        if (this.sortedPropertyNames.contains(propertyName)) {
            int oldIndex = this.sortedPropertyNames.indexOf(propertyName);
            String valueAtNewindex = this.sortedPropertyNames.get(targetIndex);
            this.sortedPropertyNames.set(targetIndex, propertyName);
            this.sortedPropertyNames.set(oldIndex, valueAtNewindex);
            this.firePropertyMoved(propertyName, oldIndex, targetIndex);
        }
    }

    @Override
    public TestProperty put(String key, TestProperty value) {
        if (value.getValue() != null) {
            this.values.put(key, value.getValue());
        } else {
            this.values.remove(key);
        }
        return this.get(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends TestProperty> m) {
        for (Map.Entry<? extends String, ? extends TestProperty> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public TestProperty remove(Object key) {
        return this.removeProperty((String)key);
    }

    @Override
    public RestParamProperty removeProperty(String propertyName) {
        this.values.remove(propertyName);
        RestParamProperty property = this.methodParams.removeProperty(propertyName);
        this.sortedPropertyNames.remove(propertyName);
        this.firePropertyRemoved(propertyName);
        return property;
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        if (name.equals(newName)) {
            return false;
        }
        RestParamProperty parameter = this.methodParams.getProperty(name);
        boolean renamePerformed = parameter.getParamLocation() == NewRestResourceActionBase.ParamLocation.METHOD ? this.methodParams.renameProperty(name, newName) : this.restRequest.getResource().renameProperty(name, newName);
        if (renamePerformed) {
            RestRequestConfig requestConfig = (RestRequestConfig)this.restRequest.getConfig();
            if (requestConfig.isSetParameterOrder()) {
                List<String> entryList = requestConfig.getParameterOrder().getEntryList();
                for (int i = 0; i < entryList.size(); ++i) {
                    if (!entryList.get(i).equals(name)) continue;
                    requestConfig.getParameterOrder().setEntryArray(i, newName);
                    break;
                }
            }
            this.buildPropertyNameList();
        }
        return renamePerformed;
    }

    @Override
    public void resetValues() {
        this.values.clear();
    }

    public void release() {
        this.methodParams.removeTestPropertyListener(this);
        this.clearWrappers();
    }

    @Override
    public void saveTo(Properties props) {
        int count = this.getPropertyCount();
        for (int i = 0; i < count; ++i) {
            String value;
            RestParamProperty p = this.getPropertyAt(i);
            String name = p.getName();
            String string = value = this.values.containsKey(name) ? (String)this.values.get(name) : p.getValue();
            if (value == null) {
                value = "";
            }
            props.setProperty(name, value);
        }
    }

    @Override
    public void setPropertiesLabel(String propertiesLabel) {
    }

    @Override
    public void setPropertyValue(String name, String value) {
        if (value == null) {
            this.values.remove(name);
        } else {
            this.values.put(name, value);
        }
    }

    @Override
    public int size() {
        return this.methodParams.size();
    }

    @Override
    public Collection<TestProperty> values() {
        ArrayList<TestProperty> ret = new ArrayList<TestProperty>();
        for (TestProperty p : this.methodParams.values()) {
            ret.add(this.getWrapper((RestParamProperty)p));
        }
        return ret;
    }

    private void firePropertyAdded(String name) {
        TestPropertyListener[] listenersArray;
        this.saveParameterOrder();
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyAdded(name);
        }
    }

    private void firePropertyRemoved(String name) {
        TestPropertyListener[] listenersArray;
        this.saveParameterOrder();
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRemoved(name);
        }
    }

    private void firePropertyMoved(String name, int oldIndex, int newIndex) {
        TestPropertyListener[] listenersArray;
        this.saveParameterOrder();
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyMoved(name, oldIndex, newIndex);
        }
    }

    private void firePropertyRenamed(String oldName, String newName) {
        TestPropertyListener[] listenersArray;
        this.saveParameterOrder();
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRenamed(oldName, newName);
        }
    }

    private void firePropertyValueChanged(String name, String oldValue, String newValue) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyValueChanged(name, oldValue, newValue);
        }
    }

    private void saveParameterOrder() {
        StringListConfig mapConfig = StringListConfig.Factory.newInstance();
        mapConfig.setEntryArray(this.keySet().toArray(new String[this.keySet().size()]));
        ((RestRequestConfig)this.restRequest.getConfig()).setParameterOrder(mapConfig);
    }

    private RestParamProperty getWrapper(RestParamProperty key) {
        if (!this.wrappers.containsKey(key)) {
            this.wrappers.put(key, new InternalRestParamProperty(key));
        }
        return this.wrappers.get(key);
    }

    @Override
    public void propertyAdded(String name) {
        if (this.isChangingLocationOfParameter(name)) {
            return;
        }
        if (!this.sortedPropertyNames.contains(name)) {
            this.sortedPropertyNames.add(name);
        }
        this.firePropertyAdded(name);
    }

    @Override
    public void propertyMoved(String name, int oldIndex, int newIndex) {
        this.firePropertyMoved(name, oldIndex, newIndex);
    }

    @Override
    public void propertyRemoved(String name) {
        if (this.isChangingLocationOfParameter(name)) {
            return;
        }
        this.sortedPropertyNames.remove(name);
        this.values.remove(name);
        this.firePropertyRemoved(name);
    }

    @Override
    public void propertyRenamed(String oldName, String newName) {
        if (this.values.containsKey(oldName)) {
            this.values.put(newName, this.values.get(oldName));
            this.values.remove(oldName);
        } else {
            if (this.sortedPropertyNames.contains(oldName)) {
                this.sortedPropertyNames.set(this.sortedPropertyNames.indexOf(oldName), newName);
            }
            this.firePropertyRenamed(oldName, newName);
        }
    }

    @Override
    public void propertyValueChanged(String name, String oldValue, String newValue) {
        if (!this.values.containsKey(name)) {
            this.values.put(name, newValue);
            this.firePropertyValueChanged(name, oldValue, newValue);
        }
    }

    private boolean isChangingLocationOfParameter(String name) {
        return this.parameterBeingMoved != null && this.parameterBeingMoved.equals(name);
    }

    @Override
    public List<TestProperty> getPropertyList() {
        ArrayList<TestProperty> propertyList = new ArrayList<TestProperty>();
        for (InternalRestParamProperty internalRestParamProperty : this.wrappers.values()) {
            propertyList.add(internalRestParamProperty);
        }
        return propertyList;
    }

    public class InternalRestParamProperty
    implements RestParamProperty,
    PropertyChangeListener {
        private RestParamProperty overriddenProp;
        private PropertyChangeSupport propertySupport;

        public InternalRestParamProperty(RestParamProperty override) {
            this.overriddenProp = override;
            this.overriddenProp.addPropertyChangeListener(this);
            this.propertySupport = new PropertyChangeSupport(this);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertySupport.addPropertyChangeListener(listener);
        }

        @Override
        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertySupport.addPropertyChangeListener(propertyName, listener);
        }

        @Override
        public boolean isDisableUrlEncoding() {
            return this.overriddenProp.isDisableUrlEncoding();
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertySupport.removePropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertySupport.removePropertyChangeListener(propertyName, listener);
        }

        @Override
        public void setDisableUrlEncoding(boolean encode) {
            this.overriddenProp.setDisableUrlEncoding(encode);
        }

        @Override
        public void setName(String name) {
            this.overriddenProp.setName(name);
        }

        @Override
        public String getDefaultValue() {
            return this.overriddenProp.getDefaultValue();
        }

        @Override
        public String getDescription() {
            return this.overriddenProp.getDescription();
        }

        @Override
        public ModelItem getModelItem() {
            return RestRequestParamsPropertyHolder.this.restRequest;
        }

        @Override
        public String getName() {
            return this.overriddenProp.getName();
        }

        @Override
        public QName getType() {
            return this.overriddenProp.getType();
        }

        @Override
        public String getValue() {
            if (RestRequestParamsPropertyHolder.this.values.containsKey(this.getName()) && RestRequestParamsPropertyHolder.this.values.get(this.getName()) != null) {
                return (String)RestRequestParamsPropertyHolder.this.values.get(this.getName());
            }
            return this.getDefaultValue();
        }

        @Override
        public boolean isReadOnly() {
            return this.overriddenProp.isReadOnly();
        }

        @Override
        public void setValue(String value) {
            String oldValue = this.getValue();
            if (this.getDefaultValue() != null && this.getDefaultValue().equals(value)) {
                value = null;
            }
            if (value == null) {
                RestRequestParamsPropertyHolder.this.values.remove(this.getName());
            } else {
                RestRequestParamsPropertyHolder.this.values.put(this.getName(), value);
            }
            RestRequestParamsPropertyHolder.this.firePropertyValueChanged(this.getName(), oldValue, this.getValue());
        }

        @Override
        public String[] getOptions() {
            return this.overriddenProp.getOptions();
        }

        @Override
        public boolean getRequired() {
            return this.overriddenProp.getRequired();
        }

        @Override
        public RestParamsPropertyHolder.ParameterStyle getStyle() {
            return this.overriddenProp.getStyle();
        }

        @Override
        public void setDefaultValue(String default1) {
        }

        @Override
        public void setDescription(String description) {
            this.overriddenProp.setDescription(description);
        }

        @Override
        public void setOptions(String[] arg0) {
            this.overriddenProp.setOptions(arg0);
        }

        @Override
        public void setRequired(boolean arg0) {
            this.overriddenProp.setRequired(arg0);
        }

        @Override
        public void setStyle(RestParamsPropertyHolder.ParameterStyle style) {
            this.overriddenProp.setStyle(style);
        }

        @Override
        public NewRestResourceActionBase.ParamLocation getParamLocation() {
            return this.overriddenProp.getParamLocation();
        }

        @Override
        public void setParamLocation(NewRestResourceActionBase.ParamLocation paramLocation) {
            this.overriddenProp.setParamLocation(paramLocation);
        }

        @Override
        public void setType(QName arg0) {
            this.overriddenProp.setType(arg0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertySupport.firePropertyChange(evt);
        }

        public void release() {
            this.overriddenProp.removePropertyChangeListener(this);
            this.overriddenProp = null;
            this.propertySupport = null;
        }

        @Override
        public String getPath() {
            return this.overriddenProp.getPath();
        }

        @Override
        public void setPath(String path) {
            this.overriddenProp.setPath(path);
        }

        @Override
        public boolean isRequestPart() {
            return false;
        }

        @Override
        public SchemaType getSchemaType() {
            return this.overriddenProp.getSchemaType();
        }
    }
}

