/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.InvalidOAuthParametersException;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2ClientFacade;
import com.eviware.soapui.impl.rest.actions.oauth.OltuOAuth2ClientFacade;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RefreshOAuthAccessTokenAction
extends AbstractAction {
    private static final MessageSupport messages = MessageSupport.getMessages(RefreshOAuthAccessTokenAction.class);
    private OAuth2Profile profile;

    public RefreshOAuthAccessTokenAction(OAuth2Profile profile) {
        super(messages.get("RefreshOAuthAccessTokenAction.Action.Name"));
        this.profile = profile;
        this.putValue("ShortDescription", messages.get("RefreshOAuthAccessTokenAction.Action.Description"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            this.getOAuthClientFacade().refreshAccessToken(this.profile);
        }
        catch (InvalidOAuthParametersException e) {
            UISupport.showErrorMessage(messages.get("RefreshOAuthAccessTokenAction.Error.InvalidParameters", e.getMessage()));
        }
        catch (Exception e) {
            SoapUI.logError(e, messages.get("RefreshOAuthAccessTokenAction.Error.RefreshingFailLog"));
            UISupport.showErrorMessage(messages.get("RefreshOAuthAccessTokenAction.Error.RefreshingFailMessage"));
        }
    }

    protected OAuth2ClientFacade getOAuthClientFacade() {
        return new OltuOAuth2ClientFacade();
    }
}

