/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.mock;

import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JTextFieldFormField;

public class AddEmptyRestMockResourceAction
extends AbstractSoapUIAction<RestMockService> {
    public static final String SOAPUI_ACTION_ID = "AddEmptyRestMockResourceAction";

    public AddEmptyRestMockResourceAction() {
        super("Add new mock action", "Add a new REST mock action to this mock service");
    }

    @Override
    public void perform(RestMockService mockService, Object param) {
        XFormDialog dialog = ADialogBuilder.buildDialog(Form.class);
        dialog.setOptions("Method", RestRequestInterface.HttpMethod.getMethodsAsStringArray());
        dialog.setValue("Method", RestRequestInterface.HttpMethod.GET.name());
        JTextFieldFormField formField = (JTextFieldFormField)dialog.getFormField("Resource path");
        ((JUndoableTextField)formField.getComponent()).requestFocus();
        while (dialog.show()) {
            String resourcePath = dialog.getValue("Resource path");
            String httpMethod = dialog.getValue("Method");
            if (StringUtils.hasContent(resourcePath)) {
                mockService.addEmptyMockAction(RestRequestInterface.HttpMethod.valueOf(httpMethod), resourcePath);
                break;
            }
            UISupport.showInfoMessage("The resource path can not be empty");
        }
    }

    @AForm(name="Add new mock action", description="Enter path and HTTP method for your new mock action", helpUrl="/Service-Mocking/simulating-complex-behaviour.html")
    public static interface Form {
        @AField(description="Select HTTP method", type=AField.AFieldType.COMBOBOX)
        public static final String HTTP_METHOD = "Method";
        @AField(description="Enter resource path", type=AField.AFieldType.STRING)
        public static final String RESOURCE_PATH = "Resource path";
    }
}

