/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.analytics.providers;

import com.eviware.soapui.analytics.ActionDescription;
import com.eviware.soapui.analytics.AnalyticsManager;
import com.eviware.soapui.analytics.providers.BaseAnalyticsProvider;
import com.eviware.soapui.impl.support.HttpUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class GoogleAnalyticsProvider
extends BaseAnalyticsProvider {
    private static final Logger log = Logger.getLogger(GoogleAnalyticsProvider.class);
    private static final String GA_ID = "UA-92447-22";
    private static final String CATEGORY_SESSION = "Session";
    private static final String CATEGORY_ACTION = "Action";
    private static final String CATEGORY_PGU_IN = "Plug-in";
    private static final String CATEGORY_INVALID = "[Unknown]";
    private static final String EVENT_START = "Start";
    private static final String EVENT_STOP = "Stop";
    private static final String EVENT_CUSTOM = "Custom";
    private static final String EVENT_INVALID = "[Unknown]";
    private static final String GA_URL = "http://www.google-analytics.com/collect";
    private static final String SoapUI_REVISION = "SoapUI-OS";

    public void trackAction(ActionDescription actionDescription) {
        try {
            if (AnalyticsManager.Category.LICENSE_UPDATE == actionDescription.getCategory()) {
                return;
            }
            this.sendRecord(GA_URL, this.buildParametersString(actionDescription));
            this.trackActiveScreen(actionDescription.getActionName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void trackError(Throwable error) {
        try {
            String errorParametersString = String.format("v=1&an=%s&av=%s&cd=%s&tid=%s&cid=%s&t=exception&exd=%s&exf=%s&aip=1", HttpUtils.urlEncodeWithUtf8(SoapUI_REVISION), HttpUtils.urlEncodeWithUtf8(this.getSoapUIVersion()), "undefined", GA_ID, GoogleAnalyticsProvider.getMacAddressString(), HttpUtils.urlEncodeWithUtf8(error.getLocalizedMessage()), "0");
            this.sendRecord(GA_URL, errorParametersString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String buildParametersString(ActionDescription actionDescription) throws SocketException, UnknownHostException {
        String gaParametersString = String.format("v=1&an=%s&av=%s&cd=%s&tid=%s&cid=%s&t=event&ec=%s&ea=%s&el=%s&ev=1&sr=%s&cm1=%s&aip=1", HttpUtils.urlEncodeWithUtf8(SoapUI_REVISION), HttpUtils.urlEncodeWithUtf8(this.getSoapUIVersion()), "undefined", GA_ID, GoogleAnalyticsProvider.getMacAddressString(), HttpUtils.urlEncodeWithUtf8(this.getEventCategory(actionDescription)), HttpUtils.urlEncodeWithUtf8(this.getEventAction(actionDescription)), HttpUtils.urlEncodeWithUtf8(this.getEventLabel(actionDescription)), this.getStrScreenSize(), HttpUtils.urlEncodeWithUtf8(actionDescription.getSessionId()));
        switch (actionDescription.getCategory()) {
            case SESSION_START: {
                gaParametersString = gaParametersString + "&sc=start&ua=" + HttpUtils.urlEncodeWithUtf8("SoapUI-OS/" + this.getSoapUIVersion() + " (" + this.getOsName() + " " + this.getOsVersion() + ")");
                break;
            }
            case SESSION_STOP: {
                gaParametersString = gaParametersString + "&sc=end";
            }
        }
        return gaParametersString;
    }

    private static String getMacAddressString() {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (byte aMac : mac) {
                sb.append(String.format("%d", aMac));
            }
            return sb.toString();
        }
        catch (IOException e) {
            log.warn((Object)"Couldn't determine MAC address - returning empty String");
            return "";
        }
    }

    public void trackActiveScreen(String screenName) {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%d", mac[i]));
            }
            String gaParametersString = String.format("v=1&an=%s&av=%s&cd=%s&tid=%s&cid=%s&t=screenview&cd=%s&sr=%s", HttpUtils.urlEncodeWithUtf8(SoapUI_REVISION), HttpUtils.urlEncodeWithUtf8(this.getSoapUIVersion()), "undefined", GA_ID, sb.toString(), HttpUtils.urlEncodeWithUtf8(screenName), this.getStrScreenSize());
            this.sendRecord(GA_URL, gaParametersString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private String getEventCategory(ActionDescription actionDescription) {
        switch (actionDescription.getCategory()) {
            case SESSION_START: 
            case SESSION_STOP: {
                return CATEGORY_SESSION;
            }
            case ACTION: {
                return CATEGORY_ACTION;
            }
            case CUSTOM_PLUGIN_ACTION: {
                return CATEGORY_PGU_IN;
            }
        }
        return "[Unknown]";
    }

    private String getEventAction(ActionDescription actionDescription) {
        switch (actionDescription.getCategory()) {
            case SESSION_START: {
                return EVENT_START;
            }
            case SESSION_STOP: {
                return EVENT_STOP;
            }
            case ACTION: {
                return actionDescription.getActionName();
            }
            case CUSTOM_PLUGIN_ACTION: {
                return EVENT_CUSTOM;
            }
        }
        return "[Unknown]";
    }

    private String getEventLabel(ActionDescription actionDescription) {
        switch (actionDescription.getCategory()) {
            case SESSION_START: {
                return String.format("%s %s, %s; License: %s", this.getOsName(), this.getOsVersion(), this.getStrScreenSize(), this.getLicenseDescription());
            }
        }
        return actionDescription.getParamsAsString();
    }
}

