/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.analytics.providers;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.AnalyticsProvider;
import com.eviware.soapui.settings.ProxySettings;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.DataOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;

public abstract class BaseAnalyticsProvider
implements AnalyticsProvider {
    public void trackError(Throwable error) {
    }

    public final String getOsName() {
        return System.getProperty("os.name", "n/a");
    }

    public final String getOsVersion() {
        return System.getProperty("os.version", "n/a");
    }

    public final String getJavaVersion() {
        return System.getProperty("java.version", "n/a");
    }

    public final String getUserLanguage() {
        return System.getProperty("user.language", "n/a");
    }

    public final String getUserCountry() {
        return System.getProperty("user.country", "n/a");
    }

    public final String getStrScreenSize() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        return String.format("%dx%d", (int)size.getWidth(), (int)size.getHeight());
    }

    public final Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public String getSoapUIVersion() {
        return SoapUI.SOAPUI_VERSION;
    }

    public String getLicenseType() {
        return "Open Source";
    }

    public String getLicenseDescription() {
        return "No License";
    }

    public String getInstanceId() {
        return "";
    }

    protected static String throwableToString(Throwable e) {
        StringWriter output = new StringWriter();
        e.printStackTrace(new PrintWriter(output));
        String stackTraceWithoutLineBreaks = output.toString().replaceAll("(\r|\n)+", " / ");
        return stackTraceWithoutLineBreaks.replaceAll("\\s+/\\s+", " / ");
    }

    protected HttpURLConnection initializeConnection(String connectionURL) {
        try {
            HttpURLConnection connection;
            URL url = new URL(connectionURL);
            String host = SoapUI.getSettings().getString(ProxySettings.HOST, "");
            int port = 0;
            try {
                port = Integer.parseInt(SoapUI.getSettings().getString(ProxySettings.PORT, "0"));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (SoapUI.getSettings().getBoolean(ProxySettings.ENABLE_PROXY, false) && host.compareTo("") != 0 && port != 0) {
                InetSocketAddress sa = new InetSocketAddress(host, port);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, sa);
                connection = (HttpURLConnection)url.openConnection(proxy);
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            return connection;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected boolean sendRecord(String connectionURL, String parameters) {
        if (parameters == null) {
            return false;
        }
        HttpURLConnection connection = this.initializeConnection(connectionURL);
        if (connection == null) {
            return false;
        }
        try {
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(parameters);
            wr.flush();
            wr.close();
            int responseCode = connection.getResponseCode();
            return responseCode == 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

