/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.Util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapUITools {
    private static final Logger log = LoggerFactory.getLogger(SoapUITools.class);

    public static File createTemporaryDirectory() throws IOException {
        String libDirectoryName = UUID.randomUUID().toString();
        File libDirectory = new File(System.getProperty("java.io.tmpdir"), libDirectoryName);
        if (!libDirectory.mkdir()) {
            throw new IOException("Could not create directory for unpacked JAR libraries at " + libDirectory);
        }
        SoapUITools.deleteDirectoryOnExit(libDirectory);
        return libDirectory;
    }

    public static void deleteDirectoryOnExit(final File directory) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtils.deleteDirectory((File)directory);
                }
                catch (IOException e) {
                    log.warn("Could not delete temporary directory " + directory);
                }
            }
        }));
    }

    public static Path soapuiHomeDir() {
        String homePath = System.getProperty("soapui.home");
        if (homePath == null) {
            File homeFile = new File(".");
            log.warn("System property 'soapui.home' is not set! Using this directory instead: {}", (Object)homeFile);
            return homeFile.toPath();
        }
        return SoapUITools.ensureExists(Paths.get(homePath, new String[0]));
    }

    public static Path ensureExists(Path path) {
        File file = path.toFile();
        boolean ok = true;
        if (!file.exists()) {
            ok = file.mkdirs();
        }
        if (!ok) {
            throw new RuntimeException("Cannot create local storage at: " + file);
        }
        return path;
    }

    public static String absolutePath(Path path) {
        return path.toFile().getAbsolutePath();
    }
}

