/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.monitor;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;
import org.wsi.test.monitor.ConnectionListener;
import org.wsi.test.monitor.Monitor;
import org.wsi.test.monitor.SocketConnection;
import org.wsi.test.monitor.config.Redirect;

public class ServerSocketListener
extends Thread
implements ConnectionListener {
    protected Monitor monitor = null;
    protected Redirect redirect = null;
    protected ServerSocket serverSocket = null;
    protected boolean stopServerSocket = false;
    protected Vector connectionList = new Vector();

    public ServerSocketListener(Monitor monitor, Redirect redirect) {
        this.monitor = monitor;
        this.redirect = redirect;
        this.start();
    }

    public void run() {
        block3: {
            try {
                this.serverSocket = new ServerSocket(this.redirect.getListenPort(), this.redirect.getMaxConnections());
                this.serverSocket.setSoTimeout(0);
                while (!this.stopServerSocket) {
                    Socket socket = this.serverSocket.accept();
                    if (this.stopServerSocket) continue;
                    SocketConnection socketConnection = new SocketConnection(this.monitor, this.redirect, socket);
                    socketConnection.addConnectionListener(this);
                    this.connectionList.add(socketConnection);
                }
            }
            catch (Exception exception) {
                if (exception.getMessage().equalsIgnoreCase("socket closed")) break block3;
                this.monitor.exitMonitor(exception);
            }
        }
    }

    public void shutdown() {
        try {
            Iterator iterator = this.connectionList.iterator();
            while (iterator.hasNext()) {
                ((SocketConnection)iterator.next()).shutdown();
            }
            this.stopServerSocket = true;
            this.serverSocket.setSoTimeout(1);
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connectionClosed(SocketConnection socketConnection) {
        this.connectionList.remove(socketConnection);
    }
}

