/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp10.tests;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp10.entrytypes.EkDataReferenceEntryType;
import org.wsi.test.validator.bsp10.entrytypes.EkReferenceListEntryType;
import org.wsi.test.validator.bsp10.entrytypes.EncryptedDataEntryType;
import org.wsi.test.validator.bsp10.entrytypes.EncryptedKeyEntryType;
import org.wsi.test.validator.bsp10.entrytypes.SecurityHeaderEntryType;

public class BSP3208
extends Assertion {
    public BSP3208(Element element) {
        super(element);
    }

    public boolean isApplicable(Entry entry) {
        return entry instanceof EncryptedKeyEntryType;
    }

    public boolean applyRule(Entry entry) throws ValidatorException {
        EncryptedKeyEntryType encryptedKeyEntryType = (EncryptedKeyEntryType)entry;
        Element element = encryptedKeyEntryType.getReferenceList();
        if (element == null) {
            return true;
        }
        EkReferenceListEntryType ekReferenceListEntryType = null;
        if (!EkReferenceListEntryType.getFactory().isValidElement(element)) {
            throw new ValidatorException("Problem fetching xenc:ReferenceList child of xenc:EncryptedKey");
        }
        ekReferenceListEntryType = (EkReferenceListEntryType)EkReferenceListEntryType.getFactory().newInstance(element);
        Element[] elementArray = ekReferenceListEntryType.getDataReferenceElements();
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2;
            if (!EkDataReferenceEntryType.getFactory().isValidElement(elementArray[i])) continue;
            EkDataReferenceEntryType ekDataReferenceEntryType = (EkDataReferenceEntryType)EkDataReferenceEntryType.getFactory().newInstance(elementArray[i]);
            try {
                element2 = ekDataReferenceEntryType.itemReferenced();
            }
            catch (ValidatorException validatorException) {
                return false;
            }
            if (element2 == null || !EncryptedDataEntryType.getFactory().isValidElement(element2)) continue;
            Node node = element2;
            Node node2 = element2.getParentNode();
            while (node2.getNodeType() == 1 && !SecurityHeaderEntryType.getFactory().isValidElement((Element)node2)) {
                node = node2;
                node2 = node2.getParentNode();
            }
            if (node2.getNodeType() != 1) continue;
            int n = 0;
            Node node3 = node;
            while (node3 != null) {
                node3 = node3.getPreviousSibling();
                ++n;
            }
            int n2 = 0;
            node3 = encryptedKeyEntryType.getElement();
            while (node3 != null) {
                node3 = node3.getPreviousSibling();
                ++n2;
            }
            if (n > n2) continue;
            return false;
        }
        return true;
    }
}

