/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.selenesedriver;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.util.Map;
import org.openqa.selenium.internal.selenesedriver.ElementFunction;

public class SendKeys
extends ElementFunction<Void> {
    @Override
    public Void apply(Selenium selenium, Map<String, ?> args) {
        String locator = this.getLocator(args);
        CharSequence[] allKeys = (CharSequence[])args.get("value");
        StringBuilder builder = new StringBuilder();
        CharSequence[] charSequenceArray = allKeys;
        int n = allKeys.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence seq = charSequenceArray[n2];
            builder.append(seq);
            ++n2;
        }
        if (this.isFileInput(selenium, locator)) {
            String toType = builder.toString();
            if (this.isLocalFile(toType)) {
                toType = this.convertToFileUrl(toType);
            }
            selenium.attachFile(locator, toType);
        } else {
            String script = String.format("(function() { var e = selenium.browserbot.findElement('%s');if (bot.userAgent.FIREFOX_EXTENSION && Components && Components['classes'] && XPCNativeWrapper) {  e = core.firefox.unwrap(e);}bot.action.type(e, '%s');})();", locator, builder.toString().replaceAll("'", "\\'"));
            selenium.getEval(script);
        }
        return null;
    }

    private String convertToFileUrl(String toType) {
        return new File(toType).toURI().toString();
    }

    private boolean isFileInput(Selenium selenium, String locator) {
        try {
            String type = selenium.getAttribute(String.valueOf(locator) + "@type");
            return "file".equals(type.toLowerCase());
        }
        catch (SeleniumException seleniumException) {
            return false;
        }
    }

    private boolean isLocalFile(String name) {
        File file = new File(name);
        return file.exists() && file.canRead();
    }
}

