/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Cookie {
    private final String name;
    private final String value;
    private final String path;
    private final String domain;
    private final Date expiry;
    private final boolean isSecure;

    public Cookie(String name, String value, String path, Date expiry) {
        this(name, value, null, path, expiry);
    }

    public Cookie(String name, String value, String domain, String path, Date expiry) {
        this(name, value, domain, path, expiry, false);
    }

    public Cookie(String name, String value, String domain, String path, Date expiry, boolean isSecure) {
        this.name = name;
        this.value = value;
        this.path = path == null || "".equals(path) ? "/" : path;
        this.domain = Cookie.stripPort(domain);
        this.isSecure = isSecure;
        this.expiry = expiry != null ? new Date(expiry.getTime() / 1000L * 1000L) : null;
        this.validate();
    }

    public Cookie(String name, String value) {
        this(name, value, "/", null);
    }

    public Cookie(String name, String value, String path) {
        this(name, value, path, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    private static String stripPort(String domain) {
        return domain == null ? null : domain.split(":")[0];
    }

    protected void validate() {
        if (this.name == null || "".equals(this.name) || this.value == null || this.path == null) {
            throw new IllegalArgumentException("Required attributes are not set or any non-null attribute set to null");
        }
        if (this.name.indexOf(59) != -1) {
            throw new IllegalArgumentException("Cookie names cannot contain a ';': " + this.name);
        }
        if (this.domain != null && this.domain.contains(":")) {
            throw new IllegalArgumentException("Domain should not contain a port: " + this.domain);
        }
    }

    public String toString() {
        return String.valueOf(this.name) + "=" + this.value + (this.expiry == null ? "" : "; expires=" + new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss z").format(this.expiry)) + ("".equals(this.path) ? "" : "; path=" + this.path) + (this.domain == null ? "" : "; domain=" + this.domain) + (this.isSecure ? ";secure;" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (!this.name.equals(cookie.name)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(cookie.value) : cookie.value != null);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class Builder {
        private final String name;
        private final String value;
        private String path;
        private String domain;
        private Date expiry;
        private boolean secure;

        public Builder(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Builder domain(String host) {
            this.domain = Cookie.stripPort(host);
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder expiresOn(Date expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder isSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.domain, this.path, this.expiry, this.secure);
        }
    }
}

