/*
 * Decompiled with CFR 0.152.
 */
package core;

import commandline.CmdArgsParser;
import commandline.ProgressBar;
import core.Starter;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import xmlparser.XmlConfigReader;

public class Reverser
extends Thread {
    private String htmlAttributes = null;
    private String[] htmlAttributes_arr = null;
    private String[] htmlElements = null;
    private HtmlUnitDriver driver = null;
    private XmlConfigReader xmlConfig = null;
    private int num_injections;
    private static ProgressBar bar = new ProgressBar();
    private static HashMap<String, List<String>> allowedElements = new HashMap();
    private static int j = 0;

    public Reverser(String[] elements, String attributes, String[] htmlAttributes_arr, int length) {
        this.htmlElements = elements;
        this.htmlAttributes = attributes;
        this.htmlAttributes_arr = htmlAttributes_arr;
        this.num_injections = length;
        CmdArgsParser args = Starter.getParsedArgs();
        this.xmlConfig = new XmlConfigReader(args.getConfigfileName());
        if (args.getProxyInfo() != null) {
            String proxy_conf = args.getProxyInfo();
            Proxy proxy = new Proxy();
            proxy.setHttpProxy(proxy_conf).setFtpProxy(proxy_conf).setSslProxy(proxy_conf);
            DesiredCapabilities cap = new DesiredCapabilities();
            cap.setCapability("proxy", proxy);
            this.driver = new HtmlUnitDriver(cap);
        } else {
            this.driver = new HtmlUnitDriver();
        }
        if (args.getStartConfigfileName() != null) {
            XmlConfigReader xmlConfigStart = new XmlConfigReader(args.getStartConfigfileName());
            xmlConfigStart.commonInject(this.driver, null, 0);
        }
    }

    @Override
    public void run() {
        String first_delimiter = new BigInteger(130, new SecureRandom()).toString(16);
        int i = 0;
        for (String element : this.htmlElements) {
            bar.update(j, this.num_injections);
            ++j;
            String delimiter = first_delimiter + ++i;
            String current = "<" + element + " " + this.htmlAttributes + ">X</" + element + ">";
            this.inject(delimiter + current + delimiter);
            Reverser.checkReversion(delimiter, element, this.htmlAttributes_arr, allowedElements, this.driver);
        }
        this.driver.quit();
    }

    public void inject(String injection) {
        this.xmlConfig.commonInject(this.driver, injection, 0);
    }

    public static void checkReversion(String delimiter, String element, String[] htmlAttributes, HashMap<String, List<String>> allowedElements, HtmlUnitDriver driver) {
        String reflection = null;
        Pattern pattern = Pattern.compile(delimiter + "(.*)" + delimiter, 32);
        Matcher match = pattern.matcher(driver.getPageSource().replace("\n", ""));
        if (match.find() && (reflection = match.group().replace(delimiter, "").trim()) != null && reflection.trim().contains("<" + element)) {
            LinkedList<String> currentAttributes = new LinkedList<String>();
            for (String attribute : htmlAttributes) {
                if (!reflection.contains(attribute + "=\"X\"") && !reflection.contains(attribute.toLowerCase() + "=\"X\"")) continue;
                currentAttributes.add(attribute);
            }
            allowedElements.put(element, currentAttributes.size() == 0 ? null : currentAttributes);
        }
    }

    public static HashMap<String, List<String>> getAllowedElements() {
        return allowedElements;
    }
}

