/*
 * Decompiled with CFR 0.152.
 */
package commandline;

public class ProgressBar {
    private StringBuilder progress;
    private boolean broken = false;

    public ProgressBar() {
        this.init();
    }

    public void update(int done, int total) {
        char[] workchars = new char[]{'|', '/', '-', '\\'};
        String format = "\r%s%3d%% %s %c";
        int percent = ++done * 100 / total;
        int extrachars = percent / 2 - this.progress.length();
        while (extrachars-- > 0) {
            this.progress.append('#');
        }
        System.out.printf(format, this.broken ? "[!]" : "   ", percent, this.progress, Character.valueOf(workchars[done % workchars.length]));
        if (done == total) {
            System.out.flush();
            System.out.println();
            this.init();
        }
    }

    private void init() {
        this.progress = new StringBuilder(60);
    }

    public void setBroken() {
        this.broken = true;
    }

    public boolean getBroken() {
        return this.broken;
    }
}

