/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location
extends SimpleScriptable {
    private static final Pattern DECODE_HASH_PATTERN = Pattern.compile("%([\\dA-F]{2})");
    private static final Log LOG = LogFactory.getLog(Location.class);
    private static final String UNKNOWN = "null";
    private Window window_;
    private String hash_;

    public void initialize(Window window) {
        this.window_ = window;
        if (this.window_ != null && this.window_.getWebWindow().getEnclosedPage() != null) {
            this.jsxSet_hash(this.window_.getWebWindow().getEnclosedPage().getWebResponse().getWebRequest().getUrl().getRef());
        }
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || String.class.equals(hint)) {
            return this.jsxGet_href();
        }
        return super.getDefaultValue(hint);
    }

    public String toString() {
        if (this.window_ != null) {
            return this.jsxGet_href();
        }
        return "[Uninitialized]";
    }

    public void jsxFunction_assign(String url) throws IOException {
        this.jsxSet_href(url);
    }

    public void jsxFunction_reload(boolean force) throws IOException {
        String url = this.jsxGet_href();
        if (UNKNOWN.equals(url)) {
            LOG.error("Unable to reload location: current URL is unknown.");
        } else {
            this.jsxSet_href(url);
        }
    }

    public void jsxFunction_replace(String url) throws IOException {
        this.window_.getWebWindow().getHistory().removeCurrent();
        this.jsxSet_href(url);
    }

    public String jsxFunction_toString() {
        return this.jsxGet_href();
    }

    public String jsxGet_href() {
        Page page = this.window_.getWebWindow().getEnclosedPage();
        if (page == null) {
            return UNKNOWN;
        }
        try {
            String s;
            URL url = page.getWebResponse().getWebRequest().getUrl();
            boolean encodeHash = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LOCATION_HASH_IS_DECODED);
            String hash = this.getHash(encodeHash);
            if (hash != null) {
                url = UrlUtils.getUrlWithNewRef(url, hash);
            }
            if ((s = url.toExternalForm()).startsWith("file:/") && !s.startsWith("file:///")) {
                s = "file:///" + s.substring("file:/".length());
            }
            return s;
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), e);
            return page.getWebResponse().getWebRequest().getUrl().toExternalForm();
        }
    }

    public void jsxSet_href(String newLocation) throws IOException {
        HtmlPage page = (HtmlPage)Location.getWindow(this.getStartingScope()).getWebWindow().getEnclosedPage();
        if (newLocation.startsWith("javascript:")) {
            String script = newLocation.substring(11);
            page.executeJavaScriptIfPossible(script, "new location value", 1);
            return;
        }
        try {
            URL url = page.getFullyQualifiedUrl(newLocation);
            if (StringUtils.isEmpty(newLocation)) {
                boolean dropFilename = page.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.ANCHOR_EMPTY_HREF_NO_FILENAME);
                if (dropFilename) {
                    String path = url.getPath();
                    path = path.substring(0, path.lastIndexOf(47) + 1);
                    url = UrlUtils.getUrlWithNewPath(url, path);
                    url = UrlUtils.getUrlWithNewRef(url, null);
                } else {
                    url = UrlUtils.getUrlWithNewRef(url, null);
                }
            }
            WebWindow webWindow = this.getWindow().getWebWindow();
            webWindow.getWebClient().download(webWindow, "", new WebRequest(url), newLocation.endsWith("#"), "JS set location");
        }
        catch (MalformedURLException e) {
            LOG.error("jsxSet_location('" + newLocation + "') Got MalformedURLException", e);
            throw e;
        }
    }

    public String jsxGet_search() {
        String search = this.getUrl().getQuery();
        if (search == null) {
            return "";
        }
        return "?" + search;
    }

    public void jsxSet_search(String search) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), search));
    }

    public String jsxGet_hash() {
        boolean decodeHash = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LOCATION_HASH_IS_DECODED);
        String hash = this.hash_;
        if (decodeHash && this.hash_ != null) {
            hash = this.decodeHash(hash);
        }
        if (!StringUtils.isEmpty(hash)) {
            return "#" + hash;
        }
        return "";
    }

    private String getHash(boolean encoded) {
        if (this.hash_ == null || this.hash_.length() == 0) {
            return null;
        }
        if (encoded) {
            return UrlUtils.encodeAnchor(this.hash_);
        }
        return this.hash_;
    }

    public void jsxSet_hash(String hash) {
        if (hash != null && hash.length() > 0 && '#' == hash.charAt(0)) {
            hash = hash.substring(1);
        }
        this.hash_ = hash;
    }

    private String decodeHash(String hash) {
        if (hash.indexOf(37) == -1) {
            return hash;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = DECODE_HASH_PATTERN.matcher(hash);
        while (m.find()) {
            String code = m.group(1);
            char u = (char)Character.digit(code.charAt(0), 16);
            char l = (char)Character.digit(code.charAt(1), 16);
            char replacement = (char)((u << 4) + l);
            m.appendReplacement(sb, "");
            sb.append(replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String jsxGet_hostname() {
        return this.getUrl().getHost();
    }

    public void jsxSet_hostname(String hostname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
    }

    public String jsxGet_host() {
        URL url = this.getUrl();
        int port = url.getPort();
        String host = url.getHost();
        if (port == -1) {
            return host;
        }
        return host + ":" + port;
    }

    public void jsxSet_host(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index != -1) {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            hostname = host;
            port = -1;
        }
        URL url1 = UrlUtils.getUrlWithNewHost(this.getUrl(), hostname);
        URL url2 = UrlUtils.getUrlWithNewPort(url1, port);
        this.setUrl(url2);
    }

    public String jsxGet_pathname() {
        if (WebClient.URL_ABOUT_BLANK == this.getUrl()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_ABOUT_BLANK_HAS_EMPTY_PATH)) {
                return "";
            }
            return "/blank";
        }
        return this.getUrl().getPath();
    }

    public void jsxSet_pathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    public String jsxGet_port() {
        int port = this.getUrl().getPort();
        if (port == -1) {
            return "";
        }
        return Integer.toString(port);
    }

    public void jsxSet_port(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    public String jsxGet_protocol() {
        return this.getUrl().getProtocol() + ":";
    }

    public void jsxSet_protocol(String protocol) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewProtocol(this.getUrl(), protocol));
    }

    private URL getUrl() {
        return this.window_.getWebWindow().getEnclosedPage().getWebResponse().getWebRequest().getUrl();
    }

    private void setUrl(URL url) throws IOException {
        this.window_.getWebWindow().getWebClient().getPage(this.window_.getWebWindow(), new WebRequest(url));
    }
}

