/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JavaScriptExecutionJob
extends JavaScriptJob {
    private static final Log LOG = LogFactory.getLog(JavaScriptExecutionJob.class);
    private final String label_;
    private transient WeakReference<WebWindow> window_;

    public JavaScriptExecutionJob(int initialDelay, Integer period, String label, WebWindow window) {
        super(initialDelay, period);
        this.label_ = label;
        this.window_ = new WeakReference<WebWindow>(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        WebWindow w = (WebWindow)this.window_.get();
        if (w == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing " + this + ".");
        }
        try {
            HtmlPage page = (HtmlPage)w.getEnclosedPage();
            if (w.getEnclosedPage() != page || !w.getWebClient().getWebWindows().contains(w)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The page that originated this job doesn't exist anymore. Execution cancelled.");
                }
                return;
            }
            if (w.isClosed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Enclosing window is now closed. Execution cancelled.");
                }
                return;
            }
            this.runJavaScript(page);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished executing " + this + ".");
            }
        }
    }

    public String toString() {
        return "JavaScript Execution Job " + this.getId() + ": " + this.label_;
    }

    protected abstract void runJavaScript(HtmlPage var1);
}

