/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.javascript.MethodWrapper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptableWrapper
extends ScriptableObject {
    private final Map<String, Method> properties_ = new HashMap<String, Method>();
    private Method getByIndexMethod_;
    private final Object javaObject_;
    private final String jsClassName_;
    private Method getByNameFallback_;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScriptableWrapper(Scriptable scope, Object javaObject, Class<?> staticType) {
        this.javaObject_ = javaObject;
        this.setParentScope(scope);
        if (!NodeList.class.equals(staticType) && !NamedNodeMap.class.equals(staticType)) throw new RuntimeException("Unknown type: " + staticType.getName());
        try {
            this.jsClassName_ = ClassUtils.getShortClassName(staticType);
            Method length = javaObject.getClass().getMethod("getLength", ArrayUtils.EMPTY_CLASS_ARRAY);
            this.properties_.put("length", length);
            Method item = javaObject.getClass().getMethod("item", Integer.TYPE);
            this.defineProperty("item", new MethodWrapper("item", staticType, new Class[]{Integer.TYPE}), 0);
            Method toString = this.getClass().getMethod("jsToString", ArrayUtils.EMPTY_CLASS_ARRAY);
            this.defineProperty("toString", new FunctionObject("toString", toString, this), 0);
            this.getByIndexMethod_ = item;
            if (!NamedNodeMap.class.equals(staticType)) return;
            Method getNamedItem = javaObject.getClass().getMethod("getNamedItem", String.class);
            this.defineProperty("getNamedItem", new MethodWrapper("getNamedItem", staticType, new Class[]{String.class}), 0);
            this.getByNameFallback_ = getNamedItem;
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Method not found", e);
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object byName;
        Object fromSuper;
        Method propertyGetter = this.properties_.get(name);
        Object response = propertyGetter != null ? this.invoke(propertyGetter) : ((fromSuper = super.get(name, start)) != Scriptable.NOT_FOUND ? fromSuper : ((byName = this.invoke(this.getByNameFallback_, new Object[]{name})) != null ? byName : Scriptable.NOT_FOUND));
        return Context.javaToJS(response, ScriptableObject.getTopLevelScope(start));
    }

    @Override
    public boolean has(String name, Scriptable start) {
        return this.properties_.containsKey(name) || super.has(name, start);
    }

    protected Object invoke(Method method) {
        return this.invoke(method, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    protected Object invoke(Method method, Object[] args) {
        try {
            return method.invoke(this.javaObject_, args);
        }
        catch (Exception e) {
            throw new RuntimeException("Invocation of method on java object failed", e);
        }
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.getByIndexMethod_ != null) {
            Object byIndex = this.invoke(this.getByIndexMethod_, new Object[]{index});
            return Context.javaToJS(byIndex, ScriptableObject.getTopLevelScope(start));
        }
        return super.get(index, start);
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            return this.jsToString();
        }
        return super.getDefaultValue(hint);
    }

    public String jsToString() {
        return "[object " + this.getClassName() + "]";
    }

    @Override
    public String getClassName() {
        return this.jsClassName_;
    }

    public Object getWrappedObject() {
        return this.javaObject_;
    }
}

