/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResponseData
implements Serializable {
    private final int statusCode_;
    private final String statusMessage_;
    private final List<NameValuePair> responseHeaders_;
    private final DownloadedContent downloadedContent_;

    public WebResponseData(byte[] body, int statusCode, String statusMessage, List<NameValuePair> responseHeaders) throws IOException {
        this(new DownloadedContent.InMemory(body), statusCode, statusMessage, responseHeaders);
    }

    @Deprecated
    public WebResponseData(InputStream bodyStream, int statusCode, String statusMessage, List<NameValuePair> responseHeaders) throws IOException {
        this(HttpWebConnection.downloadContent(bodyStream), statusCode, statusMessage, responseHeaders);
    }

    protected WebResponseData(int statusCode, String statusMessage, List<NameValuePair> responseHeaders) throws IOException {
        this.statusCode_ = statusCode;
        this.statusMessage_ = statusMessage;
        this.responseHeaders_ = Collections.unmodifiableList(responseHeaders);
        this.downloadedContent_ = new DownloadedContent.InMemory(ArrayUtils.EMPTY_BYTE_ARRAY);
    }

    public WebResponseData(DownloadedContent responseBody, int statusCode, String statusMessage, List<NameValuePair> responseHeaders) throws IOException {
        this.statusCode_ = statusCode;
        this.statusMessage_ = statusMessage;
        this.responseHeaders_ = Collections.unmodifiableList(responseHeaders);
        this.downloadedContent_ = responseBody;
    }

    private InputStream getStream(InputStream stream, List<NameValuePair> headers) throws IOException {
        if (stream == null) {
            return null;
        }
        String encoding = null;
        for (NameValuePair header : headers) {
            String headerName = header.getName().trim();
            if (!"content-encoding".equalsIgnoreCase(headerName)) continue;
            encoding = header.getValue();
            break;
        }
        if (encoding != null && StringUtils.contains(encoding, "gzip")) {
            stream = new GZIPInputStream(stream);
        } else if (encoding != null && StringUtils.contains(encoding, "deflate")) {
            stream = new InflaterInputStream(stream);
        }
        return stream;
    }

    public byte[] getBody() {
        try {
            return IOUtils.toByteArray(this.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream() {
        try {
            return this.getStream(this.downloadedContent_.getInputStream(), this.getResponseHeaders());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<NameValuePair> getResponseHeaders() {
        return this.responseHeaders_;
    }

    public int getStatusCode() {
        return this.statusCode_;
    }

    public String getStatusMessage() {
        return this.statusMessage_;
    }
}

