/*
 * Decompiled with CFR 0.152.
 */
package org.cf.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.opcode.ConstOp;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.opcode.SPutOp;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualClass;
import org.cf.smalivm.type.VirtualField;
import org.cf.smalivm.type.VirtualMethod;

public class EnumAnalyzer {
    private static final String METHOD_DESCRIPTOR = "<clinit>()V";
    private final Map<String, String> originalNameToObfuscatedName;
    private final VirtualMachine vm;

    public EnumAnalyzer(VirtualMachine vm) {
        this.vm = vm;
        this.originalNameToObfuscatedName = new HashMap<String, String>();
    }

    public void analyze(Class<? extends Enum> enumClass) {
        ClassManager classManager = this.vm.getClassManager();
        VirtualClass virtualClass = classManager.getVirtualClass(enumClass);
        VirtualMethod method = virtualClass.getMethod(METHOD_DESCRIPTOR);
        ExecutionGraph graph = this.vm.spawnInstructionGraph(method);
        ArrayList<VirtualField> fields = new ArrayList<VirtualField>(virtualClass.getFields());
        boolean lookingForField = false;
        String name = null;
        for (int address : graph.getAddresses()) {
            ExecutionNode node = graph.getTemplateNode(address);
            Op op = node.getOp();
            if (op instanceof ConstOp) {
                ConstOp cop = (ConstOp)op;
                if (cop.getConstantType() != ConstOp.ConstantType.STRING) continue;
                name = (String)cop.getLiteral();
                lookingForField = true;
                continue;
            }
            if (!(op instanceof SPutOp) || !lookingForField) continue;
            SPutOp sput = (SPutOp)op;
            String obfuscatedName = sput.getFieldReference().getName();
            this.originalNameToObfuscatedName.put(name, obfuscatedName);
            lookingForField = false;
        }
    }

    public String getObfuscatedName(String name) {
        return this.originalNameToObfuscatedName.get(name);
    }
}

