/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.type;

import java.lang.reflect.Modifier;
import org.cf.smalivm.type.UnknownValue;
import org.cf.smalivm.type.VirtualClass;
import org.cf.smalivm.type.VirtualClassItem;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderField;

public class VirtualField
extends VirtualClassItem {
    private final BuilderField field;

    VirtualField(BuilderField field, VirtualClass virtualClass) {
        super(field, virtualClass);
        this.field = field;
    }

    public BuilderField getField() {
        return this.field;
    }

    public Object getInitialValue() {
        if (!Modifier.isStatic(this.field.getAccessFlags())) {
            return new UnknownValue();
        }
        BuilderEncodedValues.BuilderEncodedValue bev = this.field.getInitialValue();
        if (bev != null) {
            switch (bev.getValueType()) {
                case 0: {
                    return ((ByteEncodedValue)((Object)bev)).getValue();
                }
                case 2: {
                    return ((ShortEncodedValue)((Object)bev)).getValue();
                }
                case 3: {
                    return Character.valueOf(((CharEncodedValue)((Object)bev)).getValue());
                }
                case 4: {
                    return ((IntEncodedValue)((Object)bev)).getValue();
                }
                case 6: {
                    return ((LongEncodedValue)((Object)bev)).getValue();
                }
                case 16: {
                    return Float.valueOf(((FloatEncodedValue)((Object)bev)).getValue());
                }
                case 17: {
                    return ((DoubleEncodedValue)((Object)bev)).getValue();
                }
                case 23: {
                    return ((StringEncodedValue)((Object)bev)).getValue();
                }
                case 31: {
                    return ((BooleanEncodedValue)((Object)bev)).getValue();
                }
            }
        } else {
            switch (this.getType().charAt(0)) {
                case 'Z': {
                    return false;
                }
                case 'B': {
                    return (byte)0;
                }
                case 'S': {
                    return (short)0;
                }
                case 'C': {
                    return Character.valueOf('\u0000');
                }
                case 'I': {
                    return 0;
                }
                case 'J': {
                    return 0L;
                }
                case 'F': {
                    return Float.valueOf(0.0f);
                }
                case 'D': {
                    return 0.0;
                }
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public String getSignature() {
        return ReferenceUtil.getFieldDescriptor(this.field);
    }

    @Override
    public String toString() {
        return this.getSignature();
    }

    public String getType() {
        return this.field.getType();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getAccessFlags());
    }
}

