/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.type;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualArray;
import org.cf.smalivm.type.VirtualField;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.smalivm.type.VirtualPrimitive;
import org.cf.smalivm.type.VirtualRealMethod;
import org.cf.smalivm.type.VirtualType;
import org.cf.util.ClassNameUtils;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualClass
extends VirtualType {
    private static final Logger log = LoggerFactory.getLogger(VirtualClass.class.getSimpleName());
    private final BuilderClassDef classDef;
    private Set<VirtualClass> ancestors;
    private Map<String, VirtualMethod> methodDescriptorToMethod;
    private Map<String, VirtualField> fieldNameToField;

    VirtualClass(BuilderClassDef classDef) {
        super(classDef, classDef.getType(), ClassNameUtils.internalToBinary(classDef.getType()), ClassNameUtils.internalToSource(classDef.getType()));
        this.classDef = classDef;
        this.methodDescriptorToMethod = null;
        this.fieldNameToField = null;
    }

    private static void getAncestors0(VirtualClass virtualClass, Set<VirtualClass> ancestors) {
        if (ancestors.contains(virtualClass)) {
            return;
        }
        ancestors.add(virtualClass);
        for (VirtualClass ancestor : virtualClass.getImmediateAncestors()) {
            VirtualClass.getAncestors0(ancestor, ancestors);
        }
    }

    public Set<VirtualClass> getImmediateAncestors() {
        ClassManager classManager = VirtualClass.getClassManager();
        HashSet<VirtualClass> parents = new HashSet<VirtualClass>();
        BuilderClassDef classDef = this.getClassDef();
        for (String classInterface : classDef.getInterfaces()) {
            parents.add(classManager.getVirtualClass(classInterface));
        }
        if (classDef.getSuperclass() != null) {
            parents.add(classManager.getVirtualClass(classDef.getSuperclass()));
        }
        return parents;
    }

    public Set<VirtualClass> getAncestors() {
        if (this.ancestors != null) {
            return this.ancestors;
        }
        this.ancestors = new LinkedHashSet<VirtualClass>(3);
        VirtualClass.getAncestors0(this, this.ancestors);
        this.ancestors.remove(this);
        return this.ancestors;
    }

    @Override
    @Nullable
    public final VirtualField getField(String fieldName) {
        VirtualField field = this.getField0(fieldName);
        if (field != null) {
            return field;
        }
        for (VirtualClass ancestor : this.getAncestors()) {
            field = ancestor.getField0(fieldName);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    @Override
    public Collection<VirtualField> getFields() {
        if (this.fieldNameToField == null) {
            this.fieldNameToField = this.buildFieldsMap();
        }
        LinkedList<VirtualField> fields = new LinkedList<VirtualField>();
        fields.addAll(this.fieldNameToField.values());
        return fields;
    }

    @Override
    @Nullable
    public VirtualMethod getMethod(String methodDescriptor) {
        VirtualMethod method = this.getMethod0(methodDescriptor);
        if (method != null) {
            return method;
        }
        for (VirtualClass ancestor : this.getAncestors()) {
            method = ancestor.getMethod0(methodDescriptor);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    @Override
    public Collection<VirtualMethod> getMethods() {
        if (this.methodDescriptorToMethod == null) {
            this.methodDescriptorToMethod = this.buildMethodsMap();
        }
        LinkedList<VirtualMethod> methods = new LinkedList<VirtualMethod>();
        methods.addAll(this.methodDescriptorToMethod.values());
        return methods;
    }

    @Override
    public boolean instanceOf(VirtualType targetType) {
        if (targetType instanceof VirtualPrimitive) {
            return false;
        }
        if (targetType.getName().equals("Ljava/lang/Object;")) {
            return true;
        }
        if (targetType instanceof VirtualArray) {
            return false;
        }
        if (this.equals(targetType)) {
            return true;
        }
        for (VirtualType virtualType : this.getAncestors()) {
            if (!virtualType.equals(targetType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public BuilderClassDef getClassDef() {
        return this.classDef;
    }

    @Override
    public boolean isInnerClassOf(VirtualType parentClass) {
        return this.getBinaryName().startsWith(parentClass.getBinaryName() + "$");
    }

    @Override
    public String getPackage() {
        String binaryName = this.getBinaryName();
        int lastDot = binaryName.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return binaryName.substring(0, lastDot);
    }

    @Override
    public boolean isSamePackageOf(VirtualType otherClass) {
        return this.getPackage().equals(otherClass.getPackage());
    }

    private Map<String, VirtualField> buildFieldsMap() {
        HashMap<String, VirtualField> fields = new HashMap<String, VirtualField>();
        for (BuilderField builderField : this.getClassDef().getFields()) {
            String name = builderField.getName();
            if (builderField.getName().startsWith("shadow$_")) continue;
            VirtualField field = new VirtualField(builderField, this);
            fields.put(name, field);
        }
        return fields;
    }

    private Map<String, VirtualMethod> buildMethodsMap() {
        HashMap<String, VirtualRealMethod> methods = new HashMap<String, VirtualRealMethod>();
        for (BuilderMethod method : this.getClassDef().getMethods()) {
            String descriptor = ReferenceUtil.getMethodDescriptor(method).split("->")[1];
            VirtualRealMethod virtualMethod = new VirtualRealMethod(method, this);
            methods.put(descriptor, virtualMethod);
        }
        return Collections.unmodifiableMap(methods);
    }

    private VirtualField getField0(String fieldName) {
        if (this.fieldNameToField == null) {
            this.fieldNameToField = this.buildFieldsMap();
        }
        return this.fieldNameToField.get(fieldName);
    }

    private VirtualMethod getMethod0(String methodDescriptor) {
        if (this.methodDescriptorToMethod == null) {
            this.methodDescriptorToMethod = this.buildMethodsMap();
        }
        return this.methodDescriptorToMethod.get(methodDescriptor);
    }
}

