/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.type;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.cf.smalivm.type.VirtualArrayMethod;
import org.cf.smalivm.type.VirtualField;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.smalivm.type.VirtualType;
import org.cf.util.ClassNameUtils;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;

public class VirtualArray
extends VirtualType {
    private final int dimensionRank;
    private Set<VirtualType> ancestors;
    private Map<String, VirtualArrayMethod> methodDescriptorToMethod;

    VirtualArray(TypeReference typeReference) {
        super(typeReference, typeReference.getType(), ClassNameUtils.internalToBinary(typeReference.getType()), ClassNameUtils.internalToSource(typeReference.getType()));
        this.dimensionRank = ClassNameUtils.getDimensionCount(typeReference.getType());
    }

    private static String buildRankString(int rank) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rank; ++i) {
            sb.append('[');
        }
        return sb.toString();
    }

    private static void getAncestors0(VirtualType virtualType, Set<VirtualType> ancestors) {
        if (ancestors.contains(virtualType)) {
            return;
        }
        ancestors.add(virtualType);
        for (VirtualType virtualType2 : virtualType.getImmediateAncestors()) {
            VirtualArray.getAncestors0(virtualType2, ancestors);
        }
    }

    @Override
    public Set<? extends VirtualType> getImmediateAncestors() {
        HashSet<VirtualType> parents = new HashSet<VirtualType>();
        VirtualType componentType = this.getComponentType();
        if (componentType.isPrimitive()) {
            String objectType = VirtualArray.buildRankString(this.dimensionRank - 1) + "Ljava/lang/Object;";
            VirtualType virtualType = classManager.getVirtualType(objectType);
            parents.add(virtualType);
        } else {
            for (VirtualType virtualType : componentType.getImmediateAncestors()) {
                String ancestorName = '[' + virtualType.getTypeReference().getType();
                VirtualArray parent = (VirtualArray)classManager.getVirtualType(ancestorName);
                parents.add(parent);
            }
            if (componentType.getName().endsWith("Ljava/lang/Object;")) {
                parents.add(componentType);
            }
        }
        return parents;
    }

    @Override
    public Set<? extends VirtualType> getAncestors() {
        if (this.ancestors != null) {
            return this.ancestors;
        }
        this.ancestors = new LinkedHashSet<VirtualType>();
        VirtualArray.getAncestors0(this, this.ancestors);
        this.ancestors.remove(this);
        return this.ancestors;
    }

    @Override
    public VirtualField getField(String fieldName) {
        return null;
    }

    @Override
    public Collection<VirtualField> getFields() {
        return Collections.emptyList();
    }

    @Override
    public VirtualMethod getMethod(String methodDescriptor) {
        VirtualArrayMethod method = this.getMethod0(methodDescriptor);
        if (method != null) {
            return method;
        }
        for (VirtualType virtualType : this.getAncestors()) {
            if (!(virtualType instanceof VirtualArray) || (method = ((VirtualArray)virtualType).getMethod0(methodDescriptor)) == null) continue;
            return method;
        }
        return null;
    }

    @Override
    public Collection<VirtualMethod> getMethods() {
        if (this.methodDescriptorToMethod == null) {
            this.methodDescriptorToMethod = this.buildMethodsMap();
        }
        LinkedList<VirtualMethod> methods = new LinkedList<VirtualMethod>();
        methods.addAll(this.methodDescriptorToMethod.values());
        return methods;
    }

    @Override
    public boolean instanceOf(VirtualType targetType) {
        if (this.equals(targetType)) {
            return true;
        }
        for (VirtualType virtualType : this.getAncestors()) {
            if (!virtualType.equals(targetType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public VirtualType getBaseType() {
        String baseType = ClassNameUtils.getComponentBase(this.getName());
        return classManager.getVirtualType(baseType);
    }

    public VirtualType getComponentType() {
        String componentType = ClassNameUtils.getComponentType(this.getName());
        return classManager.getVirtualType(componentType);
    }

    private VirtualArrayMethod getMethod0(String methodDescriptor) {
        if (this.methodDescriptorToMethod == null) {
            this.methodDescriptorToMethod = this.buildMethodsMap();
        }
        return this.methodDescriptorToMethod.get(methodDescriptor);
    }

    private Map<String, VirtualArrayMethod> buildMethodsMap() {
        HashMap<String, VirtualArrayMethod> methods = new HashMap<String, VirtualArrayMethod>(2);
        String methodDescriptor = "clone()Ljava/lang/Object;";
        String methodSignature = this.getName() + "->" + methodDescriptor;
        BuilderTypeReference reference = classManager.getFrameworkDexBuilder().internTypeReference(methodSignature);
        VirtualArrayMethod method = new VirtualArrayMethod(reference, this);
        methods.put(methodDescriptor, method);
        return methods;
    }
}

