/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.type;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.cf.smalivm.type.ClassManager;
import org.jf.baksmali.Main;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.writer.builder.DexBuilder;

public class ClassManagerFactory {
    private static final String TEMP_DIR_NAME = "simplify";

    private static File disassemble(File file) throws IOException {
        Path tempDir = Files.createTempDirectory(TEMP_DIR_NAME, new FileAttribute[0]);
        String[] args = new String[]{"disassemble", "--use-locals", "--sequential-labels", "--code-offsets", file.getAbsolutePath(), "--output", tempDir.toString()};
        Main.main(args);
        return tempDir.toFile();
    }

    public ClassManager build() throws IOException {
        DexBuilder dexBuilder = new DexBuilder(Opcodes.getDefault());
        return this.build(dexBuilder);
    }

    public ClassManager build(int outputAPILevel) throws IOException {
        DexBuilder dexBuilder = new DexBuilder(Opcodes.forApi(outputAPILevel));
        return this.build(dexBuilder);
    }

    public ClassManager build(DexBuilder dexBuilder) {
        return new ClassManager(dexBuilder);
    }

    public ClassManager build(File inFile, DexBuilder dexBuilder) throws IOException {
        if (!inFile.exists()) {
            throw new RuntimeException("Input Smali path does not exist: " + inFile);
        }
        File smaliPath = inFile.isFile() ? ClassManagerFactory.disassemble(inFile) : inFile;
        return new ClassManager(dexBuilder, smaliPath);
    }

    public ClassManager build(String smaliPath) throws IOException {
        return this.build(smaliPath, new DexBuilder(Opcodes.getDefault()));
    }

    public ClassManager build(String smaliPath, int outputAPILevel) throws IOException {
        return this.build(new File(smaliPath), outputAPILevel);
    }

    public ClassManager build(File smaliPath, int outputAPILevel) throws IOException {
        return this.build(smaliPath, new DexBuilder(Opcodes.forApi(outputAPILevel)));
    }

    public ClassManager build(String smaliPath, DexBuilder dexBuilder) throws IOException {
        return this.build(new File(smaliPath), dexBuilder);
    }
}

