/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.type;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cf.smalivm.dex.SmaliFile;
import org.cf.smalivm.dex.SmaliFileFactory;
import org.cf.smalivm.dex.SmaliParser;
import org.cf.smalivm.type.VirtualArray;
import org.cf.smalivm.type.VirtualClass;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.smalivm.type.VirtualPrimitive;
import org.cf.smalivm.type.VirtualType;
import org.cf.util.ClassNameUtils;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassManager {
    private static final Logger log = LoggerFactory.getLogger(ClassManager.class.getSimpleName());
    private final HashMap<String, VirtualClass> classNameToClass;
    private final Map<String, SmaliFile> classNameToSmaliFile;
    private final SmaliFileFactory smaliFileFactory;
    private final DexBuilder dexBuilder;
    private final DexBuilder frameworkDexBuilder = new DexBuilder(Opcodes.getDefault());
    private Set<String> frameworkClassNames = null;
    private Set<String> nonFrameworkClassNames = null;

    ClassManager(DexBuilder dexBuilder) {
        this(dexBuilder, false);
        this.cacheSmaliFiles(this.smaliFileFactory.getSmaliFiles());
    }

    private ClassManager(DexBuilder dexBuilder, boolean internalOnly) {
        this.dexBuilder = dexBuilder;
        this.smaliFileFactory = new SmaliFileFactory();
        this.classNameToClass = new HashMap();
        this.classNameToSmaliFile = new HashMap<String, SmaliFile>();
        VirtualType.setClassManager(this);
    }

    ClassManager(DexBuilder dexBuilder, File smaliPath) throws IOException {
        this(dexBuilder, false);
        this.cacheSmaliFiles(this.smaliFileFactory.getSmaliFiles(smaliPath));
    }

    public Set<String> getClassNames() {
        return this.classNameToSmaliFile.keySet();
    }

    public DexBuilder getDexBuilder() {
        return this.dexBuilder;
    }

    public Set<String> getFrameworkClassNames() {
        if (this.frameworkClassNames == null) {
            this.frameworkClassNames = this.classNameToSmaliFile.keySet().parallelStream().filter(this.smaliFileFactory::isFrameworkClass).collect(Collectors.toSet());
        }
        return this.frameworkClassNames;
    }

    public Collection<VirtualClass> getLoadedClasses() {
        return this.classNameToClass.values();
    }

    public VirtualMethod getMethod(String methodSignature) {
        String[] parts = methodSignature.split("->");
        String className = parts[0];
        String methodDescriptor = parts[1];
        return this.getMethod(className, methodDescriptor);
    }

    public VirtualMethod getMethod(String className, String methodDescriptor) {
        VirtualClass virtualClass = this.getVirtualClass(className);
        return ((VirtualType)virtualClass).getMethod(methodDescriptor);
    }

    public Set<String> getNonFrameworkClassNames() {
        if (this.nonFrameworkClassNames == null) {
            this.nonFrameworkClassNames = this.classNameToSmaliFile.keySet().parallelStream().filter(className -> !this.smaliFileFactory.isFrameworkClass((String)className)).collect(Collectors.toSet());
        }
        return this.nonFrameworkClassNames;
    }

    public VirtualClass getVirtualClass(Class<?> klazz) {
        return this.getVirtualClass(ClassNameUtils.toInternal(klazz));
    }

    public VirtualClass getVirtualClass(String className) {
        return (VirtualClass)this.getVirtualType(className);
    }

    public VirtualType getVirtualType(TypeReference typeReference) {
        char first = typeReference.charAt(0);
        if (first == 'L') {
            String className = typeReference.getType();
            this.parseClassIfNecessary(className);
            return this.classNameToClass.get(className);
        }
        if (first == '[') {
            return new VirtualArray(typeReference);
        }
        if (ClassNameUtils.isPrimitive(typeReference.getType())) {
            return new VirtualPrimitive(typeReference);
        }
        throw new RuntimeException("Unrecognized type: " + typeReference);
    }

    public VirtualType getVirtualType(Class<?> typeClass) {
        return this.getVirtualType(ClassNameUtils.toInternal(typeClass));
    }

    public VirtualType getVirtualType(String typeSignature) {
        BuilderTypeReference typeReference = this.getFrameworkDexBuilder().internTypeReference(typeSignature);
        return this.getVirtualType(typeReference);
    }

    public boolean isFrameworkClass(VirtualType virtualClass) {
        return this.smaliFileFactory.isFrameworkClass(virtualClass.getName());
    }

    public boolean isSafeFrameworkClass(VirtualType virtualClass) {
        return this.smaliFileFactory.isSafeFrameworkClass(virtualClass.getName());
    }

    DexBuilder getFrameworkDexBuilder() {
        return this.frameworkDexBuilder;
    }

    private void cacheSmaliFiles(Set<SmaliFile> smaliFiles) {
        for (SmaliFile smaliFile : smaliFiles) {
            this.classNameToSmaliFile.put(smaliFile.getClassName(), smaliFile);
        }
    }

    private BuilderClassDef parseClass(String className, DexBuilder builder) {
        BuilderClassDef classDef;
        SmaliFile smaliFile = this.classNameToSmaliFile.get(className);
        try {
            InputStream is = smaliFile.open();
            classDef = SmaliParser.parse(smaliFile.getPath(), is, builder);
            is.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading class definition: " + className, e);
        }
        return classDef;
    }

    private void parseClassIfNecessary(String className) {
        if (this.classNameToClass.containsKey(className)) {
            return;
        }
        SmaliFile smaliFile = this.classNameToSmaliFile.get(className);
        if (smaliFile == null) {
            throw new RuntimeException("Can't find Smali file for " + className);
        }
        boolean isFramework = this.smaliFileFactory.isFrameworkClass(className);
        DexBuilder builder = isFramework ? this.frameworkDexBuilder : this.dexBuilder;
        BuilderClassDef classDef = this.parseClass(className, builder);
        VirtualClass virtualClass = new VirtualClass(classDef);
        this.classNameToClass.put(className, virtualClass);
    }
}

