/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import java.lang.constant.Constable;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.MethodLocation;

public class UnaryMathOp
extends MethodStateOp {
    private final int destRegister;
    private final int srcRegister;

    UnaryMathOp(MethodLocation location, MethodLocation child, int destRegister, int srcRegister) {
        super(location, child);
        this.destRegister = destRegister;
        this.srcRegister = srcRegister;
    }

    private static String getResultTypeName(String opName) {
        String[] parts = opName.split("-");
        String type = parts[parts.length - 1];
        String resultType = null;
        if ("int".equals(type)) {
            resultType = "I";
        } else if ("long".equals(type)) {
            resultType = "J";
        } else if ("float".equals(type)) {
            resultType = "F";
        } else if ("byte".equals(type)) {
            resultType = "B";
        } else if ("char".equals(type)) {
            resultType = "C";
        } else if ("double".equals(type)) {
            resultType = "D";
        } else if ("short".equals(type)) {
            resultType = "S";
        }
        return resultType;
    }

    public int getDestRegister() {
        return this.destRegister;
    }

    public int getSrcRegister() {
        return this.srcRegister;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        HeapItem resultItem;
        HeapItem item = mState.readRegister(this.srcRegister);
        String type = UnaryMathOp.getResultTypeName(this.getName());
        if (item.isUnknown()) {
            resultItem = HeapItem.newUnknown(type);
        } else {
            Object resultValue = this.perform(item.getValue(), this.getName());
            resultItem = new HeapItem(resultValue, type);
        }
        mState.assignRegister(this.destRegister, resultItem);
    }

    @Override
    public String toString() {
        return this.getName() + " r" + this.destRegister + ", r" + this.srcRegister;
    }

    private Object perform(Object value, String opName) {
        Constable resultValue = null;
        if (opName.startsWith("double")) {
            Double typedValue = Utils.getDoubleValue(value);
            if (opName.endsWith("float")) {
                resultValue = Float.valueOf(typedValue.floatValue());
            } else if (opName.endsWith("int")) {
                resultValue = typedValue.intValue();
            } else if (opName.endsWith("long")) {
                resultValue = typedValue.longValue();
            }
        } else if (opName.startsWith("float")) {
            Float typedValue = Utils.getFloatValue(value);
            if (opName.endsWith("double")) {
                resultValue = typedValue.doubleValue();
            } else if (opName.endsWith("int")) {
                resultValue = typedValue.intValue();
            } else if (opName.endsWith("long")) {
                resultValue = typedValue.longValue();
            }
        } else if (opName.startsWith("long")) {
            Long typedValue = Utils.getLongValue(value);
            if (opName.endsWith("double")) {
                resultValue = typedValue.doubleValue();
            } else if (opName.endsWith("int")) {
                resultValue = typedValue.intValue();
            } else if (opName.endsWith("float")) {
                resultValue = Float.valueOf(typedValue.floatValue());
            }
        } else if (opName.startsWith("int")) {
            Integer typedValue = Utils.getIntegerValue(value);
            if (opName.endsWith("byte")) {
                resultValue = typedValue.byteValue();
            } else if (opName.endsWith("char")) {
                resultValue = Character.valueOf((char)typedValue.intValue());
            } else if (opName.endsWith("short")) {
                resultValue = typedValue.shortValue();
            } else if (opName.endsWith("double")) {
                resultValue = typedValue.doubleValue();
            } else if (opName.endsWith("long")) {
                resultValue = typedValue.longValue();
            } else if (opName.endsWith("float")) {
                resultValue = Float.valueOf(typedValue.floatValue());
            }
        } else if (opName.startsWith("neg")) {
            if (opName.endsWith("double")) {
                Double typedValue = Utils.getDoubleValue(value);
                resultValue = -typedValue.doubleValue();
            } else if (opName.endsWith("float")) {
                Float typedValue = Utils.getFloatValue(value);
                resultValue = Float.valueOf(-typedValue.floatValue());
            } else if (opName.endsWith("int")) {
                Integer typedValue = Utils.getIntegerValue(value);
                resultValue = -typedValue.intValue();
            } else if (opName.endsWith("long")) {
                Long typedValue = Utils.getLongValue(value);
                resultValue = -typedValue.longValue();
            }
        } else if (opName.startsWith("not")) {
            if (opName.endsWith("int")) {
                Integer typedValue = Utils.getIntegerValue(value);
                resultValue = ~typedValue.intValue();
            } else if (opName.endsWith("long")) {
                Long typedValue = Utils.getLongValue(value);
                resultValue = typedValue ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        return resultValue;
    }
}

