/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPayloadOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(SwitchPayloadOp.class.getSimpleName());
    private static final int SWITCH_OP_CODE_UNITS = 3;
    private final TIntObjectMap<MethodLocation> addressToLocation;
    private final TIntIntMap targetKeyToOffset;

    SwitchPayloadOp(MethodLocation location, TIntObjectMap<MethodLocation> addressToLocation, TIntIntMap targetKeyToOffset) {
        super(location);
        this.targetKeyToOffset = targetKeyToOffset;
        this.addressToLocation = addressToLocation;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        MethodLocation returnLocation = mState.getPseudoInstructionReturnInstruction();
        int branchFromAddress = returnLocation.getCodeAddress() - 3;
        HeapItem targetItem = mState.readResultRegister();
        if (targetItem.isUnknown()) {
            List<MethodLocation> childList = this.getTargets(branchFromAddress, this.targetKeyToOffset);
            childList.add(returnLocation);
            MethodLocation[] children = childList.toArray(new MethodLocation[childList.size()]);
            node.setChildLocations(children);
            return;
        }
        int targetKey = Utils.getIntegerValue(targetItem.getValue());
        if (this.targetKeyToOffset.containsKey(targetKey)) {
            int targetOffset = branchFromAddress + this.targetKeyToOffset.get(targetKey);
            MethodLocation child = this.addressToLocation.get(targetOffset);
            node.setChildLocations(child);
            return;
        }
        node.setChildLocations(returnLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" [");
        int[] keys = this.targetKeyToOffset.keys();
        Arrays.sort(keys);
        for (int key : keys) {
            int offset = this.targetKeyToOffset.get(key);
            sb.append(key).append(" -> :addr_").append(offset).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(']');
        return sb.toString();
    }

    private List<MethodLocation> getTargets(int branchFromAddress, TIntIntMap targetKeyToOffset) {
        int[] offsets = targetKeyToOffset.values();
        LinkedList<MethodLocation> targets = new LinkedList<MethodLocation>();
        for (int offset : offsets) {
            int targetOffset = branchFromAddress + offset;
            targets.add(this.addressToLocation.get(targetOffset));
        }
        return targets;
    }
}

