/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import org.cf.smalivm.SideEffect;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.ExecutionContextOp;
import org.cf.smalivm.type.VirtualField;
import org.jf.dexlib2.builder.MethodLocation;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.util.ReferenceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPutOp
extends ExecutionContextOp {
    private static final Logger log = LoggerFactory.getLogger(SPutOp.class.getSimpleName());
    private final FieldReference fieldReference;
    private final VirtualField actualField;
    private final int valueRegister;
    private final VirtualMachine vm;

    SPutOp(MethodLocation location, MethodLocation child, int valueRegister, FieldReference fieldReference, VirtualField actualField, VirtualMachine vm) {
        super(location, child);
        this.fieldReference = fieldReference;
        this.actualField = actualField;
        this.valueRegister = valueRegister;
        this.vm = vm;
    }

    public FieldReference getFieldReference() {
        return this.fieldReference;
    }

    public VirtualField getActualField() {
        return this.actualField;
    }

    public int getValueRegister() {
        return this.valueRegister;
    }

    public VirtualMachine getVm() {
        return this.vm;
    }

    @Override
    public void execute(ExecutionNode node, ExecutionContext context) {
        MethodState mState = context.getMethodState();
        HeapItem item = mState.readRegister(this.valueRegister);
        this.vm.getStaticFieldAccessor().putField(context, this.actualField, item);
    }

    @Override
    public SideEffect.Level getSideEffectLevel() {
        return SideEffect.Level.WEAK;
    }

    @Override
    public String toString() {
        return this.getName() + " r" + this.valueRegister + ", " + ReferenceUtil.getFieldDescriptor(this.fieldReference);
    }
}

