/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import gnu.trove.map.TIntObjectMap;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.opcode.MoveOp;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.opcode.OpFactory;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.MethodLocation;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.TwoRegisterInstruction;

public class MoveOpFactory
implements OpFactory {
    private static MoveOp.MoveType getMoveType(String opName) {
        if (opName.contains("-result")) {
            return MoveOp.MoveType.RESULT;
        }
        if (opName.contains("-exception")) {
            return MoveOp.MoveType.EXCEPTION;
        }
        return MoveOp.MoveType.REGISTER;
    }

    @Override
    public Op create(MethodLocation location, TIntObjectMap<MethodLocation> addressToLocation, VirtualMachine vm) {
        MethodLocation child = Utils.getNextLocation(location, addressToLocation);
        BuilderInstruction instruction = (BuilderInstruction)location.getInstruction();
        String opName = instruction.getOpcode().name;
        int toRegister = ((OneRegisterInstruction)((Object)instruction)).getRegisterA();
        MoveOp.MoveType moveType = MoveOpFactory.getMoveType(opName);
        switch (moveType) {
            case RESULT: 
            case EXCEPTION: {
                return new MoveOp(location, child, toRegister, moveType);
            }
            case REGISTER: {
                int targetRegister = ((TwoRegisterInstruction)((Object)instruction)).getRegisterB();
                return new MoveOp(location, child, toRegister, targetRegister);
            }
        }
        return null;
    }
}

