/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(IfOp.class.getSimpleName());
    private final IfType ifType;
    private final int register1;
    private final MethodLocation target;
    private boolean compareToZero;
    private int register2;

    IfOp(MethodLocation location, MethodLocation child, IfType ifType, MethodLocation target, int register1) {
        super(location, new MethodLocation[]{child, target});
        this.ifType = ifType;
        this.target = target;
        this.register1 = register1;
        this.compareToZero = true;
    }

    IfOp(MethodLocation location, MethodLocation child, IfType ifType, MethodLocation target, int register1, int register2) {
        this(location, child, ifType, target, register1);
        this.register2 = register2;
        this.compareToZero = false;
    }

    private static boolean isTrue(IfType ifType, int cmp) {
        boolean isTrue = false;
        switch (ifType) {
            case EQUAL: {
                isTrue = cmp == 0;
                break;
            }
            case GREATER: {
                isTrue = cmp == 1;
                break;
            }
            case GREATER_OR_EQUAL: {
                isTrue = cmp >= 0;
                break;
            }
            case LESS: {
                isTrue = cmp == -1;
                break;
            }
            case LESS_OR_EQUAL: {
                isTrue = cmp <= 0;
                break;
            }
            case NOT_EQUAL: {
                isTrue = cmp != 0;
            }
        }
        return isTrue;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        Integer aIntValue;
        int cmp;
        HeapItem rhsItem;
        HeapItem lhsItem = mState.readRegister(this.register1);
        HeapItem heapItem = rhsItem = this.compareToZero ? new HeapItem(0, "I") : mState.readRegister(this.register2);
        if (lhsItem.isUnknown() || rhsItem.isUnknown()) {
            return;
        }
        Object lhs = lhsItem.getValue();
        Object rhs = rhsItem.getValue();
        if (this.compareToZero) {
            if (lhs == null) {
                cmp = 0;
            } else if ((lhs instanceof Number || lhs instanceof Boolean || lhs instanceof Character) && (rhs instanceof Number || rhs instanceof Boolean || rhs instanceof Character)) {
                aIntValue = Utils.getIntegerValue(lhs);
                cmp = aIntValue.compareTo((Integer)rhs);
            } else {
                cmp = lhs == rhs ? 0 : 1;
            }
        } else if ((lhs instanceof Number || lhs instanceof Boolean || lhs instanceof Character) && (rhs instanceof Number || rhs instanceof Boolean || rhs instanceof Character)) {
            aIntValue = Utils.getIntegerValue(lhs);
            Integer bIntValue = Utils.getIntegerValue(rhs);
            cmp = aIntValue.compareTo(bIntValue);
        } else {
            int n = cmp = lhs == rhs ? 0 : 1;
        }
        if (log.isTraceEnabled()) {
            log.trace("IF compare: {} vs {} = {}", lhs, rhs, cmp);
        }
        int childIndex = IfOp.isTrue(this.ifType, cmp) ? 1 : 0;
        node.setChildLocations(this.getChildren()[childIndex]);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" r").append(this.register1);
        if (!this.compareToZero) {
            sb.append(", r").append(this.register2);
        }
        sb.append(", :addr_").append(this.target.getCodeAddress());
        return sb.toString();
    }

    static enum IfType {
        EQUAL,
        GREATER,
        GREATER_OR_EQUAL,
        LESS,
        LESS_OR_EQUAL,
        NOT_EQUAL;

    }
}

