/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.ExecutionContextOp;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGetOp
extends ExecutionContextOp {
    private static final Logger log = LoggerFactory.getLogger(IGetOp.class.getSimpleName());
    private final int destRegister;
    private final int instanceRegister;
    private final String fieldDescriptor;
    private final VirtualMachine vm;

    public IGetOp(MethodLocation location, MethodLocation child, int destRegister, int instanceRegister, String fieldDescriptor, VirtualMachine vm) {
        super(location, child);
        this.destRegister = destRegister;
        this.instanceRegister = instanceRegister;
        this.fieldDescriptor = fieldDescriptor;
        this.vm = vm;
    }

    @Override
    public void execute(ExecutionNode node, ExecutionContext context) {
        MethodState mState = context.getMethodState();
        HeapItem instanceItem = mState.readRegister(this.instanceRegister);
        String type = this.fieldDescriptor.split(":")[1];
        mState.assignRegister(this.destRegister, HeapItem.newUnknown(type));
    }

    @Override
    public String toString() {
        return this.getName() + " r" + this.destRegister + ", r" + this.instanceRegister + ", " + this.fieldDescriptor;
    }
}

