/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import java.lang.reflect.Array;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FillArrayDataPayloadOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(FillArrayDataPayloadOp.class.getSimpleName());
    private final List<Number> arrayElements;
    private final int elementWidth;

    private static Object getProperValue(Number number, Class<?> expectedClass) {
        Class<?> klazz = ClassUtils.wrapperToPrimitive(number.getClass());
        Comparable<Byte> value = null;
        if (klazz == Byte.TYPE) {
            value = number.byteValue();
        } else if (klazz == Short.TYPE) {
            value = number.shortValue();
        } else if (klazz == Integer.TYPE) {
            value = number.intValue();
        } else if (klazz == Long.TYPE) {
            value = number.longValue();
        }
        if (expectedClass == Boolean.TYPE) {
            value = value == 1;
        } else if (expectedClass == Character.TYPE) {
            value = Character.valueOf((char)number.shortValue());
        } else if (expectedClass == Short.TYPE) {
            value = number.shortValue();
        } else if (expectedClass == Integer.TYPE) {
            value = number.intValue();
        } else if (expectedClass == Long.TYPE) {
            value = number.longValue();
        } else if (expectedClass == Float.TYPE) {
            value = Float.valueOf(Float.intBitsToFloat(number.intValue()));
        } else if (expectedClass == Double.TYPE) {
            value = Double.longBitsToDouble(number.longValue());
        }
        return value;
    }

    FillArrayDataPayloadOp(MethodLocation location, int elementWidth, List<Number> arrayElements) {
        super(location);
        this.elementWidth = elementWidth;
        this.arrayElements = arrayElements;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        MethodState parent = mState.getParent();
        int targetRegister = parent.getRegistersAssigned()[0];
        HeapItem arrayItem = mState.peekRegister(targetRegister);
        if (!arrayItem.isUnknown()) {
            Object array = arrayItem.getValue();
            Class<?> expectedClass = array.getClass().getComponentType();
            for (int i = 0; i < this.arrayElements.size(); ++i) {
                Number number = this.arrayElements.get(i);
                Object value = FillArrayDataPayloadOp.getProperValue(number, expectedClass);
                Array.set(array, i, value);
            }
            mState.pokeRegister(targetRegister, arrayItem);
        }
        MethodLocation returnLocation = mState.getParent().getPseudoInstructionReturnInstruction();
        node.setChildLocations(returnLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(".array-data ");
        sb.append(this.elementWidth);
        for (Number number : this.arrayElements) {
            sb.append("\n\t").append(number.toString());
        }
        sb.append("\n.end array-data");
        return sb.toString();
    }
}

