/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmpOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(CmpOp.class.getSimpleName());
    private final int destRegister;
    private final int lhsRegister;
    private final int rhsRegister;

    CmpOp(MethodLocation location, MethodLocation child, int destRegister, int lhsRegister, int rhsRegister) {
        super(location, child);
        this.destRegister = destRegister;
        this.lhsRegister = lhsRegister;
        this.rhsRegister = rhsRegister;
    }

    public int getDestRegister() {
        return this.destRegister;
    }

    public int getLhsRegister() {
        return this.lhsRegister;
    }

    public int getRhsRegister() {
        return this.rhsRegister;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        HeapItem item;
        HeapItem lhsItem = mState.readRegister(this.lhsRegister);
        HeapItem rhsItem = mState.readRegister(this.rhsRegister);
        if (lhsItem.isUnknown() || rhsItem.isUnknown()) {
            item = HeapItem.newUnknown("I");
        } else {
            Number lhs = (Number)lhsItem.getValue();
            Number rhs = (Number)rhsItem.getValue();
            assert (lhs.getClass() == rhs.getClass());
            assert (lhsItem.getType().equals(rhsItem.getType()));
            int cmp = this.cmp(lhs, rhs);
            item = new HeapItem(cmp, "I");
        }
        mState.assignRegister(this.destRegister, item);
    }

    @Override
    public String toString() {
        return this.getName() + " r" + this.destRegister + ", r" + this.lhsRegister + ", r" + this.rhsRegister;
    }

    private int cmp(Number val1, Number val2) {
        boolean arg1IsNan = val1 instanceof Float && ((Float)val1).isNaN() || val1 instanceof Double && ((Double)val1).isNaN();
        boolean arg2IsNan = val2 instanceof Float && ((Float)val2).isNaN() || val2 instanceof Double && ((Double)val2).isNaN();
        int value = 0;
        if (arg1IsNan || arg2IsNan) {
            value = this.getName().startsWith("cmpg") ? 1 : -1;
        } else if (this.getName().endsWith("float")) {
            Float castVal1 = Utils.getFloatValue(val1);
            Float castVal2 = Utils.getFloatValue(val2);
            value = Float.compare(castVal1.floatValue(), castVal2.floatValue());
        } else if (this.getName().endsWith("double")) {
            Double castVal1 = Utils.getDoubleValue(val1);
            Double castVal2 = Utils.getDoubleValue(val2);
            value = Double.compare(castVal1, castVal2);
        } else {
            Long castVal1 = Utils.getLongValue(val1);
            Long castVal2 = Utils.getLongValue(val2);
            value = Long.compare(castVal1, castVal2);
        }
        return value;
    }
}

