/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import javax.annotation.Nonnull;
import org.cf.smalivm.ExceptionFactory;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.type.UnknownValue;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryMathOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(BinaryMathOp.class.getSimpleName());
    private final int arg1Register;
    private final int destRegister;
    private final MathOperandType mathOperandType;
    private final MathOperator mathOperator;
    private int arg2Register;
    private boolean hasLiteral;
    private int narrowLiteral;

    BinaryMathOp(MethodLocation location, MethodLocation child, int destRegister, int arg1Register, int otherValue, boolean hasLiteral, ExceptionFactory exceptionFactory) {
        this(location, child, destRegister, arg1Register, exceptionFactory);
        this.hasLiteral = hasLiteral;
        if (hasLiteral) {
            this.narrowLiteral = otherValue;
        } else {
            this.arg2Register = otherValue;
        }
    }

    private BinaryMathOp(MethodLocation location, MethodLocation child, int destRegister, int arg1Register, ExceptionFactory exceptionFactory) {
        super(location, child);
        this.destRegister = destRegister;
        this.arg1Register = arg1Register;
        this.mathOperator = BinaryMathOp.getMathOp(this.getName());
        this.mathOperandType = BinaryMathOp.getMathOperandType(this.getName());
        this.addException(exceptionFactory.build((Op)this, ArithmeticException.class, "/ by zero"));
    }

    private static Object doDoubleOperation(MathOperator mathOperator, Double lhs, Double rhs) {
        Double result = null;
        switch (mathOperator) {
            case ADD: {
                result = lhs + rhs;
                break;
            }
            case DIV: {
                result = lhs / rhs;
                break;
            }
            case MUL: {
                result = lhs * rhs;
                break;
            }
            case REM: {
                result = lhs % rhs;
                break;
            }
            case SUB: {
                result = lhs - rhs;
            }
        }
        return result;
    }

    private static Object doFloatOperation(MathOperator mathOperator, Float lhs, Float rhs) {
        Float result = null;
        switch (mathOperator) {
            case ADD: {
                result = Float.valueOf(lhs.floatValue() + rhs.floatValue());
                break;
            }
            case DIV: {
                result = Float.valueOf(lhs.floatValue() / rhs.floatValue());
                break;
            }
            case MUL: {
                result = Float.valueOf(lhs.floatValue() * rhs.floatValue());
                break;
            }
            case REM: {
                result = Float.valueOf(lhs.floatValue() % rhs.floatValue());
                break;
            }
            case SUB: {
                result = Float.valueOf(lhs.floatValue() - rhs.floatValue());
            }
        }
        return result;
    }

    private static Object doIntegerOperation(MathOperator mathOperator, Integer lhs, Integer rhs) {
        Integer result = null;
        try {
            switch (mathOperator) {
                case ADD: {
                    result = lhs + rhs;
                    break;
                }
                case AND: {
                    result = lhs & rhs;
                    break;
                }
                case DIV: {
                    result = lhs / rhs;
                    break;
                }
                case MUL: {
                    result = lhs * rhs;
                    break;
                }
                case OR: {
                    result = lhs | rhs;
                    break;
                }
                case REM: {
                    result = lhs % rhs;
                    break;
                }
                case RSUB: {
                    result = rhs - lhs;
                    break;
                }
                case SHL: {
                    result = lhs << (rhs & 0x1F);
                    break;
                }
                case SHR: {
                    result = lhs >> (rhs & 0x1F);
                    break;
                }
                case SUB: {
                    result = lhs - rhs;
                    break;
                }
                case USHR: {
                    result = lhs >>> (rhs & 0x1F);
                    break;
                }
                case XOR: {
                    result = lhs ^ rhs;
                }
            }
        }
        catch (ArithmeticException e) {
            return e;
        }
        return result;
    }

    private static Object doLongOperation(MathOperator mathOperator, Long lhs, Long rhs) {
        Long result = null;
        try {
            switch (mathOperator) {
                case ADD: {
                    result = lhs + rhs;
                    break;
                }
                case AND: {
                    result = lhs & rhs;
                    break;
                }
                case DIV: {
                    result = lhs / rhs;
                    break;
                }
                case MUL: {
                    result = lhs * rhs;
                    break;
                }
                case OR: {
                    result = lhs | rhs;
                    break;
                }
                case REM: {
                    result = lhs % rhs;
                    break;
                }
                case SHL: {
                    result = lhs << (int)rhs.longValue();
                    break;
                }
                case SHR: {
                    result = lhs >> (int)rhs.longValue();
                    break;
                }
                case SUB: {
                    result = lhs - rhs;
                    break;
                }
                case USHR: {
                    result = lhs >>> (int)rhs.longValue();
                    break;
                }
                case XOR: {
                    result = lhs ^ rhs;
                }
            }
        }
        catch (ArithmeticException e) {
            return e;
        }
        return result;
    }

    private static MathOperator getMathOp(String opName) {
        MathOperator result = null;
        if (opName.startsWith("add")) {
            result = MathOperator.ADD;
        } else if (opName.startsWith("sub")) {
            result = MathOperator.SUB;
        } else if (opName.startsWith("mul")) {
            result = MathOperator.MUL;
        } else if (opName.startsWith("div")) {
            result = MathOperator.DIV;
        } else if (opName.startsWith("rem")) {
            result = MathOperator.REM;
        } else if (opName.startsWith("and")) {
            result = MathOperator.AND;
        } else if (opName.startsWith("or")) {
            result = MathOperator.OR;
        } else if (opName.startsWith("xor")) {
            result = MathOperator.XOR;
        } else if (opName.startsWith("shl")) {
            result = MathOperator.SHL;
        } else if (opName.startsWith("shr")) {
            result = MathOperator.SHR;
        } else if (opName.startsWith("ushr")) {
            result = MathOperator.USHR;
        } else if (opName.startsWith("rsub")) {
            result = MathOperator.RSUB;
        }
        return result;
    }

    private static MathOperandType getMathOperandType(String opName) {
        MathOperandType result = null;
        if (opName.contains("-int")) {
            result = MathOperandType.INT;
        } else if (opName.contains("-double")) {
            result = MathOperandType.DOUBLE;
        } else if (opName.contains("-float")) {
            result = MathOperandType.FLOAT;
        } else if (opName.contains("-long")) {
            result = MathOperandType.LONG;
        }
        return result;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        HeapItem lhsItem = mState.readRegister(this.arg1Register);
        HeapItem rhsItem = this.hasLiteral ? new HeapItem(this.narrowLiteral, "I") : mState.readRegister(this.arg2Register);
        Object result = null;
        if (!lhsItem.isUnknown() && !rhsItem.isUnknown()) {
            result = this.getResult(lhsItem.getValue(), rhsItem.getValue());
            if (result instanceof Throwable) {
                Throwable exception = (Throwable)result;
                node.setException(exception);
                node.clearChildren();
                return;
            }
            node.clearExceptions();
        }
        if (null == result) {
            result = new UnknownValue();
        }
        mState.assignRegister(this.destRegister, result, this.mathOperandType.getType());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" r").append(this.destRegister).append(", r");
        boolean is2Addr = this.getName().endsWith("/2addr");
        if (is2Addr) {
            sb.append(this.arg2Register);
        } else {
            sb.append(this.arg1Register);
            if (this.hasLiteral) {
                sb.append(", 0x").append(Integer.toHexString(this.narrowLiteral));
            } else {
                sb.append(", r").append(this.arg2Register);
            }
        }
        return sb.toString();
    }

    @Nonnull
    private Object getResult(Object lhs, Object rhs) {
        Object result;
        switch (this.mathOperandType) {
            case INT: {
                lhs = Utils.getIntegerValue(lhs);
                rhs = Utils.getIntegerValue(rhs);
                result = BinaryMathOp.doIntegerOperation(this.mathOperator, (Integer)lhs, (Integer)rhs);
                break;
            }
            case LONG: {
                lhs = Utils.getLongValue(lhs);
                rhs = Utils.getLongValue(rhs);
                result = BinaryMathOp.doLongOperation(this.mathOperator, (Long)lhs, (Long)rhs);
                break;
            }
            case FLOAT: {
                lhs = Utils.getFloatValue(lhs);
                rhs = Utils.getFloatValue(rhs);
                result = BinaryMathOp.doFloatOperation(this.mathOperator, (Float)lhs, (Float)rhs);
                break;
            }
            case DOUBLE: {
                lhs = Utils.getDoubleValue(lhs);
                rhs = Utils.getDoubleValue(rhs);
                result = BinaryMathOp.doDoubleOperation(this.mathOperator, (Double)lhs, (Double)rhs);
                break;
            }
            default: {
                throw new RuntimeException("Unknown math operand class!");
            }
        }
        return result;
    }

    private static enum MathOperator {
        ADD,
        AND,
        DIV,
        MUL,
        OR,
        REM,
        RSUB,
        SHL,
        SHR,
        SUB,
        USHR,
        XOR;

    }

    private static enum MathOperandType {
        DOUBLE("D"),
        FLOAT("F"),
        INT("I"),
        LONG("J");

        private final String type;

        private MathOperandType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

