/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import java.lang.reflect.Array;
import org.cf.smalivm.ExceptionFactory;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualArray;
import org.cf.smalivm.type.VirtualClass;
import org.cf.smalivm.type.VirtualType;
import org.cf.util.ClassNameUtils;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APutOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(APutOp.class.getSimpleName());
    private final int valueRegister;
    private final int arrayRegister;
    private final int indexRegister;
    private final ClassManager classManager;
    private final ExceptionFactory exceptionFactory;

    APutOp(MethodLocation location, MethodLocation child, int putRegister, int arrayRegister, int indexRegister, ClassManager classManager, ExceptionFactory exceptionFactory) {
        super(location, child);
        this.valueRegister = putRegister;
        this.arrayRegister = arrayRegister;
        this.indexRegister = indexRegister;
        this.classManager = classManager;
        this.exceptionFactory = exceptionFactory;
        this.addException(exceptionFactory.build((Op)this, NullPointerException.class));
        this.addException(exceptionFactory.build((Op)this, ArrayIndexOutOfBoundsException.class));
    }

    private static Object castValue(String opName, Object value) {
        if (value instanceof Number) {
            if (opName.endsWith("-boolean")) {
                Integer intValue = Utils.getIntegerValue(value);
                value = intValue == 1;
            } else {
                Integer intValue = Utils.getIntegerValue(value);
                if (opName.endsWith("-byte")) {
                    value = intValue.byteValue();
                } else if (opName.endsWith("-char")) {
                    value = Character.valueOf((char)intValue.intValue());
                } else if (opName.endsWith("-short")) {
                    value = intValue.shortValue();
                } else if (opName.endsWith("-object") && intValue == 0) {
                    value = null;
                }
            }
        }
        return value;
    }

    private static boolean isOverloadedPrimitiveType(String type) {
        return ClassNameUtils.isPrimitive(type) && !"F".equals(type) && !"D".equals(type) && !"J".equals(type);
    }

    private static boolean throwsArrayStoreException(HeapItem arrayItem, HeapItem valueItem, ClassManager classManager) {
        VirtualType valueType = classManager.getVirtualType(valueItem.getType());
        VirtualType arrayTypeType = classManager.getVirtualType(arrayItem.getType());
        if (arrayTypeType instanceof VirtualClass && arrayTypeType.getName().equals("Ljava/lang/Object;")) {
            Exception e = new Exception("APutOp");
            log.warn("Attempting to store item in array of type java.lang.Object. Not enough type information to know if this may throw an exception.", e);
            return false;
        }
        VirtualArray arrayType = (VirtualArray)arrayTypeType;
        VirtualType arrayComponentType = arrayType.getComponentType();
        if (valueType.instanceOf(arrayComponentType)) {
            return false;
        }
        String valueTypeName = valueType.getName();
        String arrayComponentTypeName = arrayComponentType.getName();
        if (APutOp.isOverloadedPrimitiveType(valueTypeName) && APutOp.isOverloadedPrimitiveType(arrayComponentTypeName)) {
            return false;
        }
        boolean storingNull = !valueItem.isUnknown() && valueTypeName.equals("I") && valueItem.asInteger() == 0 && !ClassNameUtils.isPrimitive(arrayComponentTypeName);
        return !storingNull;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        HeapItem valueItem = mState.readRegister(this.valueRegister);
        HeapItem arrayItem = mState.readRegister(this.arrayRegister);
        HeapItem indexItem = mState.readRegister(this.indexRegister);
        boolean throwsStoreException = APutOp.throwsArrayStoreException(arrayItem, valueItem, this.classManager);
        if (throwsStoreException) {
            String storeType = ClassNameUtils.internalToBinary(valueItem.getType());
            Throwable exception = this.exceptionFactory.build((Op)this, ArrayStoreException.class, storeType);
            node.setException(exception);
            node.clearChildren();
            return;
        }
        if (!arrayItem.isUnknown()) {
            if (valueItem.isUnknown() || indexItem.isUnknown()) {
                String type = arrayItem.getType();
                arrayItem = HeapItem.newUnknown(type);
            } else {
                Object array = arrayItem.getValue();
                if (null == array) {
                    Throwable exception = this.exceptionFactory.build((Op)this, NullPointerException.class);
                    node.setException(exception);
                    node.clearChildren();
                    return;
                }
                int index = indexItem.asInteger();
                if (index >= Array.getLength(array)) {
                    Throwable exception = this.exceptionFactory.build((Op)this, ArrayIndexOutOfBoundsException.class);
                    node.setException(exception);
                    node.clearChildren();
                    return;
                }
                Object value = APutOp.castValue(this.getName(), valueItem.getValue());
                Array.set(array, index, value);
                node.clearExceptions();
            }
        }
        mState.assignRegister(this.arrayRegister, arrayItem);
    }

    @Override
    public String toString() {
        return this.getName() + " r" + this.valueRegister + ", r" + this.arrayRegister + ", r" + this.indexRegister;
    }
}

