/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.emulate;

import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.dex.SmaliClassLoader;
import org.cf.smalivm.emulate.ExecutionContextMethod;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.type.VirtualClass;
import org.cf.util.ClassNameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class java_lang_Class_forName
extends ExecutionContextMethod {
    private static final Logger log = LoggerFactory.getLogger(java_lang_Class_forName.class.getSimpleName());
    private static final String RETURN_TYPE = "Ljava/lang/Class;";

    java_lang_Class_forName() {
    }

    @Override
    public void execute(VirtualMachine vm, Op op, ExecutionContext context) {
        MethodState mState = context.getMethodState();
        String binaryClassName = (String)mState.peekParameter(0).getValue();
        String className = ClassNameUtils.binaryToInternal(binaryClassName);
        try {
            Class<?> value;
            if (vm.getConfiguration().isSafe(className)) {
                value = Class.forName(binaryClassName);
            } else {
                VirtualClass virtualClass;
                SmaliClassLoader classLoader = vm.getClassLoader();
                value = classLoader.loadClass(binaryClassName);
                try {
                    virtualClass = vm.getClassManager().getVirtualClass(className);
                }
                catch (RuntimeException e) {
                    throw new ClassNotFoundException();
                }
                if (!context.isClassInitialized(virtualClass) && !className.equals("Lorg/cf/obfuscated/Reflection;")) {
                    context.staticallyInitializeClassIfNecessary(virtualClass);
                    this.level = context.getClassSideEffectLevel(virtualClass);
                }
            }
            mState.assignReturnRegister(value, RETURN_TYPE);
        }
        catch (ClassNotFoundException e) {
            Throwable exception = vm.getExceptionFactory().build(op, ClassNotFoundException.class, binaryClassName);
            this.setException(exception);
        }
    }
}

