/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.emulate;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cf.smalivm.SideEffect;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.emulate.EmulatedMethod;
import org.cf.smalivm.emulate.ExecutionContextMethod;
import org.cf.smalivm.emulate.MethodStateMethod;
import org.cf.smalivm.emulate.UnknownValuesMethod;
import org.cf.smalivm.emulate.java_lang_Class_forName;
import org.cf.smalivm.emulate.java_lang_Object_getClass;
import org.cf.smalivm.emulate.java_lang_reflect_Field_get;
import org.cf.smalivm.emulate.org_cf_simplify_Utils_breakpoint;
import org.cf.smalivm.opcode.Op;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodEmulator {
    private static final Logger log = LoggerFactory.getLogger(MethodEmulator.class.getSimpleName());
    private static Map<String, Class<? extends EmulatedMethod>> emulatedMethods = new HashMap<String, Class<? extends EmulatedMethod>>();
    private final VirtualMachine vm;
    private final ExecutionContext context;
    private final String methodDescriptor;
    private final EmulatedMethod method;

    public MethodEmulator(VirtualMachine vm, ExecutionContext context, String methodDescriptor) {
        this.vm = vm;
        this.context = context;
        this.methodDescriptor = methodDescriptor;
        this.method = MethodEmulator.getMethod(methodDescriptor);
    }

    public static void addMethod(String methodDescriptor, Class<? extends EmulatedMethod> methodClass) {
        emulatedMethods.put(methodDescriptor, methodClass);
    }

    public static boolean canEmulate(String methodDescriptor) {
        return emulatedMethods.containsKey(methodDescriptor);
    }

    public static boolean canHandleUnknownValues(String methodDescriptor) {
        Class<? extends EmulatedMethod> methodClass = emulatedMethods.get(methodDescriptor);
        return methodClass != null && UnknownValuesMethod.class.isAssignableFrom(methodClass);
    }

    public static void clearMethods() {
        emulatedMethods.clear();
    }

    private static EmulatedMethod getMethod(String methodDescriptor) {
        Class<? extends EmulatedMethod> methodClass = emulatedMethods.get(methodDescriptor);
        EmulatedMethod em = null;
        try {
            em = methodClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return em;
    }

    public void emulate(Op op) {
        block4: {
            try {
                if (this.method instanceof MethodStateMethod) {
                    ((MethodStateMethod)this.method).execute(this.vm, op, this.context.getMethodState());
                } else {
                    ((ExecutionContextMethod)this.method).execute(this.vm, op, this.context);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn("Unexpected JVM exception raised while emulating {}: ", (Object)this.methodDescriptor, (Object)e);
            }
        }
    }

    public SideEffect.Level getSideEffectLevel() {
        return this.method.getSideEffectLevel();
    }

    public Set<Throwable> getExceptions() {
        return this.method.getExceptions();
    }

    static {
        MethodEmulator.addMethod("Lorg/cf/simplify/Utils;->breakpoint()V", org_cf_simplify_Utils_breakpoint.class);
        MethodEmulator.addMethod("Ljava/lang/Class;->forName(Ljava/lang/String;)Ljava/lang/Class;", java_lang_Class_forName.class);
        MethodEmulator.addMethod("Ljava/lang/reflect/Field;->get(Ljava/lang/Object;)Ljava/lang/Object;", java_lang_reflect_Field_get.class);
        MethodEmulator.addMethod("Ljava/lang/Object;->getClass()Ljava/lang/Class;", java_lang_Object_getClass.class);
    }
}

