/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.dex;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.cf.util.Utils;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.smali.smaliFlexLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmaliParser {
    public static final int DEFAULT_API_LEVEL = 15;
    private static final Logger log = LoggerFactory.getLogger(SmaliParser.class.getSimpleName());

    public static List<BuilderClassDef> parse(String path) throws Exception {
        DexBuilder dexBuilder = new DexBuilder(Opcodes.forApi(15));
        return SmaliParser.parseFiles(new File(path), dexBuilder);
    }

    public static List<BuilderClassDef> parseFiles(File file, DexBuilder dexBuilder) throws Exception {
        List<File> smaliFiles;
        if (file.isDirectory()) {
            smaliFiles = Utils.getFilesWithSmaliExtension(file);
        } else {
            smaliFiles = new ArrayList<File>();
            smaliFiles.add(file);
        }
        return SmaliParser.parseFiles(smaliFiles, dexBuilder);
    }

    public static List<BuilderClassDef> parseFiles(List<File> smaliFiles, DexBuilder dexBuilder) throws Exception {
        ArrayList<BuilderClassDef> result = new ArrayList<BuilderClassDef>();
        for (File smaliFile : smaliFiles) {
            result.add(SmaliParser.parse(smaliFile, dexBuilder));
        }
        return result;
    }

    public static BuilderClassDef parse(File smaliFile, DexBuilder dexBuilder) throws FileNotFoundException, RecognitionException {
        return SmaliParser.parse(smaliFile.getAbsolutePath(), new FileInputStream(smaliFile), dexBuilder);
    }

    public static BuilderClassDef parse(String path, InputStream is, DexBuilder dexBuilder) throws RecognitionException {
        File smaliFile = new File(path);
        InputStreamReader reader = new InputStreamReader(is, Charsets.UTF_8);
        smaliFlexLexer lexer = new smaliFlexLexer(reader, 15);
        lexer.setSourceFile(smaliFile);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        smaliParser parser = new smaliParser(tokens);
        parser.setApiLevel(15);
        smaliParser.smali_file_return result = parser.smali_file();
        if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
            throw new RuntimeException("Unable to parse: " + smaliFile);
        }
        CommonTree t = result.getTree();
        CommonTreeNodeStream treeStream = new CommonTreeNodeStream(t);
        treeStream.setTokenStream(tokens);
        smaliTreeWalker dexGen = new smaliTreeWalker(treeStream);
        dexGen.setVerboseErrors(false);
        dexGen.setDexBuilder(dexBuilder);
        BuilderClassDef classDef = (BuilderClassDef)dexGen.smali_file();
        if (dexGen.getNumberOfSyntaxErrors() != 0) {
            throw new RuntimeException("Unable to walk: " + smaliFile);
        }
        return classDef;
    }

    public static List<BuilderClassDef> parse(String path, DexBuilder dexBuilder) throws Exception {
        return SmaliParser.parseFiles(new File(path), dexBuilder);
    }
}

