/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.dex;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class SmaliFile {
    private static final Pattern CLASS_PATTERN = Pattern.compile(" (L[^;]+;)");
    private final String path;
    private final String className;
    private boolean isResource;
    private boolean isSafeFramework;

    SmaliFile(File file) {
        this(file.getAbsolutePath(), SmaliFile.getClassName(file));
    }

    SmaliFile(String path, String className) {
        this.path = path;
        this.className = className;
    }

    private static String getClassName(File inputFile) {
        try {
            Path myPath = Paths.get(inputFile.toURI());
            Stream<String> lines = Files.lines(myPath);
            Optional<String> firstClassLine = lines.filter(s2 -> s2.startsWith(".class ")).findFirst();
            lines.close();
            if (!firstClassLine.isPresent()) {
                throw new RuntimeException("Missing class directive in " + inputFile);
            }
            String line = firstClassLine.get();
            Matcher m3 = CLASS_PATTERN.matcher(line);
            if (!m3.find()) {
                throw new RuntimeException("Strange class directive: " + line);
            }
            return m3.group(1);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read class name in " + inputFile, e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isResource() {
        return this.isResource;
    }

    public void setIsSafeFramework(boolean isSafeFramework) {
        this.isSafeFramework = isSafeFramework;
    }

    public boolean isSafeFrameworkClass() {
        return this.isSafeFramework;
    }

    public InputStream open() throws IOException {
        if (this.isResource) {
            return SmaliFile.class.getClassLoader().getResourceAsStream(this.getPath());
        }
        return new FileInputStream(new File(this.path));
    }

    public String getPath() {
        return this.path;
    }

    public void setIsResource(boolean isResource) {
        this.isResource = isResource;
    }

    public String toString() {
        return this.path;
    }
}

