/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.dex;

import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cf.smalivm.dex.SmaliClassLoader;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.ClassManagerFactory;
import org.cf.smalivm.type.VirtualClass;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassBuilder {
    private static final Logger log = LoggerFactory.getLogger(ClassBuilder.class.getSimpleName());
    private final ClassManager classManager;

    public ClassBuilder(ClassManager classManager) {
        this.classManager = classManager;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String smaliPath = args[0];
        String className = args[1];
        ClassManager classManager = new ClassManagerFactory().build(smaliPath);
        VirtualClass virtualClass = classManager.getVirtualClass(className);
        ClassBuilder builder = new ClassBuilder(classManager);
        byte[] classBytes = builder.build(virtualClass.getClassDef());
        new FileOutputStream(new File("temp.class")).write(classBytes);
        System.out.println("Generated class bytes for " + virtualClass + ", size=" + classBytes.length);
        SmaliClassLoader classLoader = new SmaliClassLoader(classManager);
        classLoader.loadClass(virtualClass.getSourceName());
    }

    public byte[] build(ClassDef classDef) {
        log.debug("Building input class: {}", (Object)classDef);
        ClassWriter classWriter = new ClassWriter(1);
        this.visitClass(classDef, classWriter);
        this.visitFields(classDef.getFields(), classWriter, classDef.getAccessFlags());
        if ((classDef.getAccessFlags() & 0x4000) != 0) {
            this.visitEnumMethods(classDef, classDef.getFields(), classWriter);
        } else {
            this.visitMethods(classDef, classDef.getMethods(), classWriter);
        }
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private String buildASMSignature(ClassDef classDef) {
        String signature = null;
        for (Annotation annotation : classDef.getAnnotations()) {
            if (!annotation.getType().equals("Ldalvik/annotation/Signature;")) continue;
            StringBuilder sb = new StringBuilder();
            for (AnnotationElement annotationElement : annotation.getElements()) {
                BuilderEncodedValues.BuilderArrayEncodedValue ev = (BuilderEncodedValues.BuilderArrayEncodedValue)annotationElement.getValue();
                for (EncodedValue encodedValue : ev.getValue()) {
                    BuilderEncodedValues.BuilderStringEncodedValue value = (BuilderEncodedValues.BuilderStringEncodedValue)encodedValue;
                    sb.append(value.getValue());
                }
            }
            signature = sb.toString();
            break;
        }
        return signature;
    }

    private String buildDescriptor(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        method.getParameterTypes().forEach(sb::append);
        sb.append(')');
        sb.append(method.getReturnType());
        return sb.toString();
    }

    private String[] buildExceptions(Method method) {
        if (method.getImplementation() == null) {
            return null;
        }
        HashSet<String> exceptionTypes = new HashSet<String>();
        for (TryBlock<? extends ExceptionHandler> tryBlock : method.getImplementation().getTryBlocks()) {
            for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                String type = exceptionHandler.getExceptionType();
                if (type == null) continue;
                exceptionTypes.add(this.stripName(type));
            }
        }
        return exceptionTypes.toArray(new String[0]);
    }

    private String[] buildInterfaces(ClassDef classDef) {
        List<String> interfaces = classDef.getInterfaces();
        return (String[])interfaces.stream().map(this::stripName).toArray(size -> new String[interfaces.size()]);
    }

    private String stripName(String internalName) {
        return internalName.substring(1, internalName.length() - 1);
    }

    private void visitInnerClasses(BuilderEncodedValues.BuilderTypeEncodedValue value, ClassWriter classWriter) {
        boolean isAnonymous;
        String internalName = value.getValue();
        String fullName = this.stripName(value.getValue());
        String[] parts = fullName.split("\\$", 2);
        String outerName = parts[0];
        String innerName = parts[1];
        boolean bl = isAnonymous = innerName.equals("1") || Ints.tryParse(innerName) != null;
        if (isAnonymous) {
            innerName = null;
        }
        int innerAccess = this.classManager.getVirtualClass(internalName).getClassDef().getAccessFlags();
        classWriter.visitInnerClass(fullName, outerName, innerName, innerAccess);
    }

    private void visitEnclosingMethod(BuilderEncodedValues.BuilderMethodEncodedValue value, ClassWriter classWriter) {
        BuilderMethodReference methodRef = value.getValue();
        String owner = this.stripName(methodRef.getDefiningClass());
        String name = methodRef.getName();
        String descriptor = ReferenceUtil.getMethodDescriptor(methodRef).split("->")[1];
        String desc = descriptor.substring(descriptor.indexOf(40));
        classWriter.visitOuterClass(owner, name, desc);
    }

    private void visitClassAnnotations(Set<? extends Annotation> annotations, ClassWriter classWriter) {
        block8: for (Annotation annotation : annotations) {
            switch (annotation.getType()) {
                case "Ldalvik/annotation/EnclosingMethod;": {
                    Iterator<? extends AnnotationElement> iterator = annotation.getElements().iterator();
                    if (!iterator.hasNext()) continue block8;
                    AnnotationElement annotationElement = iterator.next();
                    BuilderEncodedValues.BuilderMethodEncodedValue v = (BuilderEncodedValues.BuilderMethodEncodedValue)annotationElement.getValue();
                    this.visitEnclosingMethod(v, classWriter);
                    break;
                }
                case "Ldalvik/annotation/MemberClasses;": {
                    for (AnnotationElement annotationElement : annotation.getElements()) {
                        BuilderEncodedValues.BuilderArrayEncodedValue ev = (BuilderEncodedValues.BuilderArrayEncodedValue)annotationElement.getValue();
                        for (EncodedValue encodedValue : ev.getValue()) {
                            BuilderEncodedValues.BuilderTypeEncodedValue value = (BuilderEncodedValues.BuilderTypeEncodedValue)encodedValue;
                            this.visitInnerClasses(value, classWriter);
                        }
                    }
                    break;
                }
            }
        }
    }

    private void visitClass(ClassDef classDef, ClassWriter classWriter) {
        int version = 52;
        int access = classDef.getAccessFlags();
        String name = this.stripName(classDef.getType());
        String signature = this.buildASMSignature(classDef);
        String superName = null;
        if (classDef.getSuperclass() != null) {
            superName = this.stripName(classDef.getSuperclass());
        }
        String[] interfaces = this.buildInterfaces(classDef);
        classWriter.visit(version, access, name, signature, superName, interfaces);
        classWriter.visitSource(classDef.getSourceFile(), null);
        this.visitClassAnnotations(classDef.getAnnotations(), classWriter);
    }

    private void visitClInitStub(MethodVisitor mv) {
        mv.visitCode();
        mv.visitInsn(177);
    }

    private void visitInitStub(ClassDef classDef, MethodVisitor mv) {
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        if (classDef.getSuperclass() != null) {
            String superName = this.stripName(classDef.getSuperclass());
            mv.visitMethodInsn(183, superName, "<init>", "()V", false);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void visitFields(Iterable<? extends Field> fields, ClassWriter classWriter, int classAccessFlags) {
        for (Field field : fields) {
            int fieldAccessFlags = field.getAccessFlags();
            if ((classAccessFlags & 0x200) != 0 && (fieldAccessFlags & 2) != 0) {
                fieldAccessFlags &= 0xFFFFFFFD;
                fieldAccessFlags |= 1;
            }
            String name = field.getName();
            String desc = field.getType();
            String signature = null;
            Object value = null;
            classWriter.visitField(fieldAccessFlags, name, desc, signature, value);
        }
    }

    private void visitMethod(ClassDef classDef, Method method, MethodVisitor mv) {
        mv.visitCode();
        String methodName = method.getName();
        if (methodName.equals("<clinit>")) {
            this.visitClInitStub(mv);
        } else if (methodName.equals("<init>")) {
            this.visitInitStub(classDef, mv);
        } else if (methodName.equals("hashCode") && method.getReturnType().equals("I")) {
            this.visitCallObjectHashCode(mv);
        } else {
            this.visitMethodStub(mv);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void visitEnumMethods(ClassDef classDef, Iterable<? extends Field> fields, ClassWriter classWriter) {
        String fieldName;
        int i;
        String name = this.stripName(classDef.getType());
        int access = 16409;
        classWriter.visitField(access, "$shadow_instance", classDef.getType(), null, null);
        MethodVisitor mv = classWriter.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        LinkedList fieldList = new LinkedList();
        fields.forEach(fieldList::add);
        List fieldNames = fieldList.stream().filter(f -> (f.getAccessFlags() & 0x4000) != 0).map(Field::getName).collect(Collectors.toList());
        fieldNames.add("$shadow_instance");
        int fieldCount = fieldNames.size();
        for (i = 0; i < fieldCount; ++i) {
            fieldName = (String)fieldNames.get(i);
            mv.visitTypeInsn(187, name);
            mv.visitInsn(89);
            mv.visitLdcInsn(fieldName);
            mv.visitIntInsn(16, i);
            mv.visitMethodInsn(183, name, "<init>", "(Ljava/lang/String;I)V", false);
            mv.visitFieldInsn(179, name, fieldName, classDef.getType());
        }
        mv.visitIntInsn(16, fieldCount);
        mv.visitTypeInsn(189, name);
        for (i = 0; i < fieldCount; ++i) {
            fieldName = (String)fieldNames.get(i);
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            mv.visitFieldInsn(178, name, fieldName, classDef.getType());
            mv.visitInsn(83);
        }
        String valuesFieldName = "$VALUES";
        for (Field field : fieldList) {
            int fieldFlags = field.getAccessFlags();
            if ((fieldFlags & 0x1000) == 0 || (fieldFlags & 2) == 0 || (fieldFlags & 8) == 0 || (fieldFlags & 0x10) == 0 || field.getType().charAt(0) != '[') continue;
            valuesFieldName = field.getName();
            break;
        }
        mv.visitFieldInsn(179, name, valuesFieldName, "[" + classDef.getType());
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = classWriter.visitMethod(2, "<init>", "(Ljava/lang/String;I)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(183, "java/lang/Enum", "<init>", "(Ljava/lang/String;I)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = classWriter.visitMethod(9, "values", "()[" + classDef.getType(), null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, name, valuesFieldName, "[" + classDef.getType());
        mv.visitInsn(89);
        mv.visitVarInsn(58, 0);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(190);
        mv.visitInsn(89);
        mv.visitVarInsn(54, 1);
        mv.visitTypeInsn(189, name);
        mv.visitInsn(89);
        mv.visitVarInsn(58, 2);
        mv.visitInsn(3);
        mv.visitVarInsn(21, 1);
        mv.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", false);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = classWriter.visitMethod(9, "valueOf", "(Ljava/lang/String;)" + classDef.getType(), null, null);
        mv.visitCode();
        mv.visitLdcInsn(Type.getType(classDef.getType()));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        mv.visitTypeInsn(192, name);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void visitMethods(ClassDef classDef, Iterable<? extends Method> methods, ClassWriter classWriter) {
        boolean hasDefaultConstructor = false;
        for (Method method : methods) {
            int access = method.getAccessFlags();
            String name = method.getName();
            String desc = this.buildDescriptor(method);
            String signature = null;
            String[] exceptions = this.buildExceptions(method);
            MethodVisitor mv = classWriter.visitMethod(access, name, desc, signature, exceptions);
            if (method.getImplementation() == null) continue;
            if (method.getName().equals("<init>") && desc.equals("()V")) {
                hasDefaultConstructor = true;
            }
            this.visitMethod(classDef, method, mv);
        }
        if (!hasDefaultConstructor) {
            boolean isInterface;
            boolean bl = isInterface = (0x200 & classDef.getAccessFlags()) != 0;
            if (!isInterface) {
                int n = 1;
                MethodVisitor mv = classWriter.visitMethod(n, "<init>", "()V", null, null);
                this.visitInitStub(classDef, mv);
            }
        }
    }

    private void visitCallObjectHashCode(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        String owner = "java/lang/Object";
        String name = "hashCode";
        String desc = "()I";
        mv.visitMethodInsn(183, owner, name, desc, false);
        mv.visitInsn(172);
    }

    private void visitMethodStub(MethodVisitor mv) {
        mv.visitTypeInsn(187, "java/lang/RuntimeException");
        mv.visitInsn(89);
        mv.visitLdcInsn("Stub!");
        String owner = "java/lang/RuntimeException";
        String name = "<init>";
        String desc = "(Ljava/lang/String;)V";
        mv.visitMethodInsn(183, owner, name, desc, false);
        mv.visitInsn(191);
    }
}

