/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.debug;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cf.smalivm.MethodExecutor;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.VirtualMachineFactory;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.debug.Breakpoint;
import org.cf.smalivm.exception.UnhandledVirtualException;
import org.cf.smalivm.opcode.InvokeOp;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualMethod;

public class Debugger {
    private final VirtualMachine vm;
    private final Stack<MethodExecutor> steppedMethodExecutors;
    private final Stack<InvokeOp> steppedInvokeOps;
    private final Set<Breakpoint> breakpoints;
    private ExecutionNode currentNode;

    public Debugger(File smaliPath, String methodSignature) throws IOException {
        this(new VirtualMachineFactory().build(smaliPath), methodSignature);
    }

    public Debugger(VirtualMachine vm, String methodSignature) {
        this.vm = vm;
        this.vm.getMethodExecutorFactory().setInteractive();
        this.steppedMethodExecutors = new Stack();
        this.steppedInvokeOps = new Stack();
        this.breakpoints = new HashSet<Breakpoint>();
        ClassManager classManager = vm.getClassManager();
        VirtualMethod virtualMethod = classManager.getMethod(methodSignature);
        if (virtualMethod == null) {
            throw new IllegalArgumentException("Method signature not found: " + methodSignature);
        }
        MethodExecutor methodExecutor = vm.getMethodExecutorFactory().build(virtualMethod);
        this.currentNode = methodExecutor.getCurrentNode();
        this.steppedMethodExecutors.push(methodExecutor);
    }

    private ExecutionNode stepIntoInvoke(InvokeOp invokeOp) throws UnhandledVirtualException {
        boolean wasLocalMethod;
        invokeOp.setDebugMode(true);
        ExecutionNode node = this.getMethodExecutor().step();
        invokeOp.setDebugMode(false);
        MethodExecutor invokedMethodExecutor = invokeOp.getDebuggedMethodExecutor();
        boolean bl = wasLocalMethod = invokedMethodExecutor != null;
        if (wasLocalMethod) {
            this.steppedMethodExecutors.push(invokedMethodExecutor);
            this.steppedInvokeOps.push(invokeOp);
        }
        return node;
    }

    private void stepOutOfInvoke() {
        MethodExecutor methodExecutor = this.steppedMethodExecutors.pop();
        InvokeOp invokeOp = this.steppedInvokeOps.pop();
        invokeOp.finishDebugLocalMethod(methodExecutor.getExecutionGraph());
    }

    public VirtualMachine getVirtualMachine() {
        return this.vm;
    }

    public ClassManager getClassManager() {
        return this.vm.getClassManager();
    }

    public ExecutionGraph getExecutionGraph() {
        return this.getMethodExecutor().getExecutionGraph();
    }

    public MethodExecutor getMethodExecutor() {
        return this.steppedMethodExecutors.peek();
    }

    public VirtualMethod getCurrentMethod() {
        return this.getExecutionGraph().getMethod();
    }

    public String getCurrentMethodSignature() {
        return this.getCurrentMethod().getSignature();
    }

    @Nonnull
    public ExecutionNode getCurrentNode() {
        return this.currentNode;
    }

    public Op getCurrentOp() {
        return this.getCurrentNode().getOp();
    }

    public int getCurrentIndex() {
        return this.getCurrentOp().getIndex();
    }

    public boolean addBreakpoint(String methodSignature, int instructionIndex) {
        Breakpoint breakpoint = new Breakpoint(methodSignature, instructionIndex);
        return this.breakpoints.add(breakpoint);
    }

    public boolean removeBreakpoint(String methodSignature, int instructionIndex) {
        Breakpoint breakpoint = new Breakpoint(methodSignature, instructionIndex);
        return this.breakpoints.remove(breakpoint);
    }

    public void clearBreakpoints() {
        this.breakpoints.clear();
    }

    public boolean isBreakpoint(String methodSignature, int instructionIndex) {
        Breakpoint breakpoint = new Breakpoint(methodSignature, instructionIndex);
        return this.breakpoints.contains(breakpoint);
    }

    public boolean isBreakpoint(ExecutionNode node) {
        String methodSignature = node.getMethod().getSignature();
        int index = node.getIndex();
        return this.isBreakpoint(methodSignature, index);
    }

    public boolean isAtBreakpoint() {
        return this.isBreakpoint(this.currentNode);
    }

    public Set<Breakpoint> getBreakpoints() {
        return this.breakpoints;
    }

    public boolean isFinished() {
        return this.getMethodExecutor().isFinished();
    }

    @Nullable
    public ExecutionNode step() throws UnhandledVirtualException {
        return this.step(true);
    }

    @Nullable
    public ExecutionNode step(boolean stepIntoInvokes) throws UnhandledVirtualException {
        boolean insideDebuggedInvoke;
        if (this.isFinished()) {
            return null;
        }
        Op currentOp = this.getCurrentOp();
        ExecutionNode stepNode = stepIntoInvokes && currentOp instanceof InvokeOp ? this.stepIntoInvoke((InvokeOp)currentOp) : this.getMethodExecutor().step();
        boolean bl = insideDebuggedInvoke = stepNode.getCallDepth() > 0;
        if (this.isFinished() && insideDebuggedInvoke) {
            this.stepOutOfInvoke();
        }
        if (this.isFinished()) {
            return null;
        }
        this.currentNode = this.getMethodExecutor().getCurrentNode();
        return this.currentNode;
    }

    public void run() throws UnhandledVirtualException {
        ExecutionNode nextNode;
        while ((nextNode = this.step(true)) != null && !this.isAtBreakpoint()) {
        }
    }
}

