/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import org.cf.util.ClassNameUtils;

public class StackTraceElement {
    private String definingClass;
    private String methodName;
    private String fileName;
    private int lineNumber;

    public StackTraceElement(String methodDescriptor, String fileName, int lineNumber) {
        String[] parts = methodDescriptor.split("->");
        this.definingClass = ClassNameUtils.internalToBinary(parts[0]);
        this.methodName = parts[1].split("\\(")[0];
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public String getDeclaringClass() {
        return this.definingClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getDeclaringClass());
        sb.append('.').append(this.getMethodName()).append('(').append(this.getFileName()).append(':').append(this.getLineNumber()).append(')');
        return sb.toString();
    }
}

