/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import javax.annotation.Nullable;
import org.cf.smalivm.context.BaseState;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.HeapItem;
import org.cf.util.ClassNameUtils;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodState
extends BaseState {
    public static final int ResultRegister = -1;
    public static final int ReturnRegister = -2;
    public static final int ReturnAddressRegister = -3;
    public static final int ThrowRegister = -4;
    public static final int ExceptionRegister = -5;
    public static final String MUTABLE_PARAMETER_HEAP = "mutable";
    public static final String METHOD_HEAP = "method";
    private static final Logger log = LoggerFactory.getLogger(MethodState.class.getSimpleName());
    private final int parameterCount;
    private final int parameterSize;
    private final TIntSet mutableParameters;

    public MethodState(ExecutionContext context, int registerCount) {
        this(context, registerCount, 0, 0);
    }

    public MethodState(ExecutionContext context, int registerCount, int parameterCount, int parameterSize) {
        super(context, registerCount);
        this.parameterCount = parameterCount;
        this.parameterSize = parameterSize;
        this.mutableParameters = new TIntHashSet(parameterCount);
    }

    MethodState(MethodState other, ExecutionContext context) {
        super(other, context);
        this.parameterCount = other.parameterCount;
        this.parameterSize = other.parameterSize;
        this.mutableParameters = new TIntHashSet(other.mutableParameters);
    }

    private MethodState(MethodState parent, ExecutionContext context, TIntSet mutableParameters) {
        super(parent, context);
        this.parameterCount = parent.parameterCount;
        this.parameterSize = parent.parameterSize;
        this.mutableParameters = parent.mutableParameters;
    }

    public void assignExceptionRegister(Throwable exception) {
        String className = ClassNameUtils.toInternal(exception.getClass());
        HeapItem item = new HeapItem(exception, className);
        this.pokeRegister(-5, item, METHOD_HEAP);
    }

    public void assignParameter(int parameterRegister, HeapItem item) {
        boolean mutable;
        this.assignRegister(parameterRegister, item, METHOD_HEAP);
        boolean bl = mutable = !item.isImmutable();
        if (mutable) {
            this.pokeRegister(parameterRegister, item, MUTABLE_PARAMETER_HEAP);
            this.mutableParameters.add(parameterRegister);
        }
    }

    public void assignParameter(int parameterRegister, Object value, String type) {
        this.assignParameter(parameterRegister, new HeapItem(value, type));
    }

    public void assignRegister(int register, HeapItem item) {
        this.assignRegister(register, item, METHOD_HEAP);
    }

    public void assignRegister(int register, Object value, String type) {
        this.assignRegister(register, new HeapItem(value, type));
    }

    public void assignRegisterAndUpdateIdentities(int register, HeapItem item) {
        this.assignRegisterAndUpdateIdentities(register, item, METHOD_HEAP);
    }

    public void assignResultRegister(HeapItem item) {
        this.assignRegister(-1, item, METHOD_HEAP);
    }

    public void assignResultRegister(Object value, String type) {
        this.assignRegister(-1, new HeapItem(value, type));
    }

    public void assignReturnRegister(HeapItem item) {
        this.pokeRegister(-2, item, METHOD_HEAP);
    }

    public void assignReturnRegister(Object value, String type) {
        this.pokeRegister(-2, new HeapItem(value, type), METHOD_HEAP);
    }

    public void assignThrowRegister(HeapItem item) {
        this.pokeRegister(-4, item, METHOD_HEAP);
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public int getParameterStart() {
        return this.getRegisterCount() - this.parameterSize;
    }

    @Override
    public MethodState getParent() {
        return (MethodState)super.getParent();
    }

    public MethodLocation getPseudoInstructionReturnInstruction() {
        return (MethodLocation)this.peekRegister(-3).getValue();
    }

    public HeapItem peekExceptionRegister() {
        return this.peekRegister(-5);
    }

    public HeapItem peekParameter(int parameterRegister) {
        HeapItem item = this.mutableParameters.contains(parameterRegister) ? this.peekRegister(parameterRegister, MUTABLE_PARAMETER_HEAP) : this.peekRegister(parameterRegister);
        return item;
    }

    @Nullable
    public HeapItem peekRegister(int register) {
        if (register == -1 && !this.hasRegister(register, METHOD_HEAP) && this.getParent() != null && !this.getParent().hasRegister(register, METHOD_HEAP)) {
            return null;
        }
        return this.peekRegister(register, METHOD_HEAP);
    }

    public HeapItem peekResultRegister() {
        return this.peekRegister(-1);
    }

    public HeapItem peekReturnRegister() {
        return this.peekRegister(-2);
    }

    public HeapItem peekThrowRegister() {
        return this.peekRegister(-4);
    }

    public void pokeRegister(int register, HeapItem item) {
        this.pokeRegister(register, item, METHOD_HEAP);
    }

    public void pokeRegister(int register, Object value, String type) {
        this.pokeRegister(register, new HeapItem(value, type));
    }

    public HeapItem readRegister(int register) {
        return this.readRegister(register, METHOD_HEAP);
    }

    public HeapItem readResultRegister() {
        HeapItem item = this.readRegister(-1, METHOD_HEAP);
        return item;
    }

    public HeapItem readReturnRegister() {
        return this.readRegister(-2);
    }

    public void setPseudoInstructionReturnLocation(MethodLocation location) {
        this.pokeRegister(-3, location, METHOD_HEAP);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean onlyPeekCachedRegisters) {
        StringBuilder sb = new StringBuilder();
        int localsCount = this.getRegisterCount() - this.getParameterCount();
        sb.append("params: ").append(this.parameterCount).append(", ");
        sb.append("locals: ").append(localsCount).append('\n');
        StringBuilder ctx = new StringBuilder();
        int register = 0;
        while (register < this.getRegisterCount()) {
            boolean isLocal;
            if (onlyPeekCachedRegisters && !this.hasRegister(register)) {
                ++register;
                continue;
            }
            ctx.append('v').append(register);
            boolean bl = isLocal = register < this.getParameterStart();
            if (!isLocal) {
                ctx.append("(p").append(register - this.getParameterStart()).append(')');
            }
            HeapItem item = this.peekRegister(register);
            ctx.append(": ").append(item).append('\n');
            int registerSize = item == null ? 1 : Utils.getRegisterSize(item.getType());
            register += registerSize;
        }
        if (this.hasRegister(-1)) {
            ctx.append("result: ").append(this.peekRegister(-1)).append('\n');
        }
        if (this.hasRegister(-2)) {
            ctx.append("return: ").append(this.peekRegister(-2)).append('\n');
        }
        if (ctx.length() > 0) {
            ctx.setLength(ctx.length() - 1);
        }
        sb.append((CharSequence)ctx);
        return sb.toString();
    }

    public boolean wasRegisterRead(int register) {
        return this.wasRegisterRead(register, METHOD_HEAP);
    }

    MethodState getChild(ExecutionContext childContext) {
        MethodState child = new MethodState(this, childContext, this.mutableParameters);
        return child;
    }

    boolean hasRegister(int register) {
        return this.hasRegister(register, METHOD_HEAP);
    }
}

