/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import com.rits.cloning.Cloner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cf.smalivm.context.HeapItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Heap {
    private static final Logger log = LoggerFactory.getLogger(Heap.class.getSimpleName());
    private final Map<String, HeapItem> keyToHeapItem = new HashMap<String, HeapItem>();
    private final Cloner cloner;
    private Heap parent;

    Heap(Cloner cloner) {
        this.cloner = cloner;
    }

    private static Set<String> getReassignedKeysBetweenChildAndAncestor(Heap child, Heap ancestor) {
        HashSet<String> reassigned = new HashSet<String>();
        for (Heap current = child; current != ancestor; current = current.getParent()) {
            reassigned.addAll(current.keySet());
        }
        return reassigned;
    }

    HeapItem get(String key) {
        if (this.hasKey(key)) {
            return this.keyToHeapItem.get(key);
        }
        Heap ancestor = this.getAncestorWithKey(key);
        if (ancestor == null) {
            if (log.isTraceEnabled()) {
                log.trace("Undefined value for {}; possibly a mistake!", (Object)key, (Object)new Exception());
            }
            return null;
        }
        HeapItem targetItem = ancestor.get(key);
        HeapItem cloneItem = this.cloneItem(targetItem);
        Set<String> reassigned = Heap.getReassignedKeysBetweenChildAndAncestor(this, ancestor);
        Set<String> potential = ancestor.keySet();
        for (String currentKey : potential) {
            if (reassigned.contains(currentKey)) continue;
            HeapItem currentItem = ancestor.get(currentKey);
            if (targetItem.getValue() != currentItem.getValue()) continue;
            this.set(currentKey, cloneItem);
        }
        return cloneItem;
    }

    HeapItem get(String heapId, int register) {
        String key = this.buildKey(heapId, register);
        return this.get(key);
    }

    Map<String, HeapItem> getKeyToItem() {
        return this.keyToHeapItem;
    }

    boolean hasKey(String key) {
        return this.keyToHeapItem.containsKey(key);
    }

    boolean hasRegister(String heapId, int register) {
        String key = this.buildKey(heapId, register);
        return this.hasKey(key);
    }

    void remove(String heapId, int register) {
        String key = this.buildKey(heapId, register);
        this.remove(key);
    }

    void set(String heapId, int register, HeapItem item) {
        String key = this.buildKey(heapId, register);
        this.set(key, item);
    }

    void set(String heapId, int register, Object value, String type) {
        this.set(heapId, register, new HeapItem(value, type));
    }

    void update(String key, HeapItem updatedItem) {
        HeapItem oldItem = this.get(key);
        if (oldItem == null || oldItem.getValue() == null) {
            this.set(key, updatedItem);
        } else {
            for (String currentKey : this.keySet()) {
                HeapItem currentItem = this.get(currentKey);
                if (!oldItem.valueIdentity(currentItem)) continue;
                this.set(currentKey, updatedItem);
            }
        }
    }

    void update(String heapId, int register, HeapItem item) {
        String key = this.buildKey(heapId, register);
        this.update(key, item);
    }

    protected Heap getParent() {
        return this.parent;
    }

    void setParent(Heap parent) {
        this.parent = parent;
    }

    private String buildKey(String heapId, int register) {
        return heapId + ':' + register;
    }

    private HeapItem cloneItem(HeapItem original) {
        Object cloneValue = this.cloner.deepClone(original.getValue());
        return new HeapItem(cloneValue, original.getType());
    }

    private Heap getAncestorWithKey(String key) {
        Heap ancestor = this;
        while (!ancestor.hasKey(key) && (ancestor = ancestor.getParent()) != null) {
        }
        return ancestor;
    }

    private Set<String> keySet() {
        return this.keyToHeapItem.keySet();
    }

    private void remove(String key) {
        this.keyToHeapItem.remove(key);
    }

    private void set(String key, HeapItem item) {
        this.keyToHeapItem.put(key, item);
    }
}

