/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import com.rits.cloning.Cloner;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cf.smalivm.SideEffect;
import org.cf.smalivm.TemplateStateFactory;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ClassState;
import org.cf.smalivm.context.ClonerFactory;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.context.Heap;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.exception.UnhandledVirtualException;
import org.cf.smalivm.exception.VirtualMachineException;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.smalivm.type.VirtualType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(ExecutionContext.class.getSimpleName());
    private final VirtualMachine vm;
    private final Map<VirtualType, ClassStatus> classToStatus;
    private final Heap heap;
    private final VirtualMethod method;
    private MethodState mState;
    private ExecutionContext parent;
    private ExecutionContext callerContext;
    private int callerAddress;
    private int callDepth;

    public ExecutionContext(VirtualMachine vm, VirtualMethod method) {
        this.vm = vm;
        this.method = method;
        Cloner cloner = ClonerFactory.build(vm);
        this.heap = new Heap(cloner);
        this.callDepth = 0;
        this.classToStatus = new HashMap<VirtualType, ClassStatus>(0);
    }

    public int getCallDepth() {
        return this.callDepth;
    }

    public int getCallerAddress() {
        return this.callerAddress;
    }

    public ExecutionContext getCallerContext() {
        return this.callerContext;
    }

    public SideEffect.Level getClassSideEffectLevel(VirtualType virtualClass) {
        ExecutionContext ancestor = this.getAncestorWithClass(virtualClass);
        if (ancestor == null) {
            return null;
        }
        return ancestor.classToStatus.get(virtualClass).getSideEffectLevel();
    }

    public Set<VirtualType> getInitializedClasses() {
        return this.classToStatus.entrySet().stream().filter(entry -> ((ClassStatus)entry.getValue()).isInitialized()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public VirtualMethod getMethod() {
        return this.method;
    }

    public MethodState getMethodState() {
        return this.mState;
    }

    public void setMethodState(MethodState mState) {
        this.mState = mState;
    }

    public ExecutionContext getParent() {
        return this.parent;
    }

    public void setParent(ExecutionContext parent) {
        this.setShallowParent(parent);
        MethodState childMethodState = parent.getMethodState().getChild(this);
        this.setMethodState(childMethodState);
    }

    public void initializeClass(ClassState cState, SideEffect.Level level) {
        this.setClassState(cState);
        this.setClassInitialized(cState.getVirtualClass(), level);
    }

    public boolean isClassInitialized(VirtualType virtualClass) {
        ExecutionContext ancestor = this.getAncestorWithClass(virtualClass);
        return ancestor != null && ancestor.classToStatus.get(virtualClass).isInitialized();
    }

    public ClassState peekClassState(VirtualType virtualClass) {
        ExecutionContext ancestor = this.getAncestorWithClass(virtualClass);
        if (ancestor == null) {
            ClassState templateClassState = TemplateStateFactory.forClass(this, virtualClass);
            this.setClassState(templateClassState);
            return templateClassState;
        }
        if (ancestor != this) {
            ClassState ancestorClassState = ancestor.peekClassState(virtualClass);
            ClassState cState = ancestorClassState.getChild(this);
            SideEffect.Level level = ancestor.getClassSideEffectLevel(virtualClass);
            this.initializeClass(cState, level);
            return cState;
        }
        return this.classToStatus.get(virtualClass).getClassState();
    }

    public ClassState readClassState(VirtualType virtualClass) {
        this.staticallyInitializeClassIfNecessary(virtualClass);
        return this.peekClassState(virtualClass);
    }

    public void registerCaller(ExecutionContext callerContext, int callerAddress) {
        this.callDepth = callerContext.getCallDepth() + 1;
        this.callerContext = callerContext;
        this.callerAddress = callerAddress;
    }

    public void setClassState(ClassState cState) {
        this.classToStatus.put(cState.getVirtualClass(), new ClassStatus(cState));
    }

    public void setShallowParent(ExecutionContext parent) {
        assert (parent.getMethodState() != null);
        this.parent = parent;
        this.callDepth = parent.getCallDepth();
        this.getHeap().setParent(parent.getHeap());
    }

    public ExecutionContext spawnChild() {
        ExecutionContext child = new ExecutionContext(this.vm, this.method);
        child.setParent(this);
        return child;
    }

    public void staticallyInitializeClassIfNecessary(VirtualType virtualClass) {
        if (this.vm.isSafe(virtualClass) || this.isClassInitialized(virtualClass)) {
            return;
        }
        for (VirtualType virtualType : virtualClass.getAncestors()) {
            int accessFlags = virtualClass.getClassDef().getAccessFlags();
            if (Modifier.isAbstract(accessFlags) || Modifier.isInterface(accessFlags) || Modifier.isNative(accessFlags)) continue;
            this.staticallyInitializeClassIfNecessary(virtualType);
        }
        VirtualMethod method = virtualClass.getMethod("<clinit>()V");
        if (method == null) {
            ClassState classState = this.peekClassState(virtualClass);
            this.initializeClass(classState, SideEffect.Level.NONE);
            return;
        }
        ExecutionContext executionContext = this.vm.spawnRootContext(method);
        ClassState cState = executionContext.peekClassState(virtualClass);
        executionContext.initializeClass(cState, SideEffect.Level.NONE);
        ExecutionGraph graph = null;
        try {
            graph = this.vm.execute(executionContext, this, null);
        }
        catch (VirtualMachineException e) {
            log.warn(e.toString());
            if (e instanceof UnhandledVirtualException) {
                // empty if block
            }
        }
        SideEffect.Level sideEffectLevel = graph == null ? SideEffect.Level.STRONG : graph.getHighestSideEffectLevel();
        this.classToStatus.get(virtualClass).setSideEffectLevel(sideEffectLevel);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean onlyPeekCachedRegisters) {
        Set<VirtualType> initializedClasses;
        StringBuilder sb = new StringBuilder();
        if (this.mState != null) {
            sb.append(this.method.getSignature()).append(" State: ").append(this.mState.toString(onlyPeekCachedRegisters));
        }
        if (sb.length() > 0) {
            sb.append('\n');
        }
        if ((initializedClasses = this.getInitializedClasses()).size() < 4) {
            for (VirtualType virtualClass : initializedClasses) {
                ClassState cState = this.classToStatus.get(virtualClass).getClassState();
                sb.append("Class state: ").append(virtualClass).append(' ').append(cState);
            }
        }
        return sb.toString();
    }

    Heap getHeap() {
        return this.heap;
    }

    private ExecutionContext getAncestorWithClass(VirtualType virtualClass) {
        ExecutionContext ancestor = this;
        do {
            ClassStatus status;
            if ((status = ancestor.classToStatus.get(virtualClass)) == null) continue;
            return ancestor;
        } while ((ancestor = ancestor.getParent()) != null);
        return null;
    }

    private void setClassInitialized(VirtualType virtualClass, SideEffect.Level level) {
        this.peekClassState(virtualClass);
        this.classToStatus.get(virtualClass).setSideEffectLevel(level);
    }

    private static class ClassStatus {
        private boolean isInitialized;
        private ClassState cState;
        private SideEffect.Level level;

        ClassStatus(ClassState cState) {
            this.cState = cState;
        }

        ClassState getClassState() {
            return this.cState;
        }

        SideEffect.Level getSideEffectLevel() {
            return this.level;
        }

        void setSideEffectLevel(SideEffect.Level level) {
            this.level = level;
            this.isInitialized = true;
        }

        boolean isInitialized() {
            return this.isInitialized;
        }
    }
}

