/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import com.rits.cloning.Cloner;
import com.rits.cloning.ObjenesisInstantiationStrategy;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.dex.SmaliClassLoader;
import org.cf.smalivm.type.ClassManager;
import org.cf.util.ClassNameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClonerFactory {
    private static final Logger log = LoggerFactory.getLogger(ClonerFactory.class.getSimpleName());
    private static final Map<ClassManager, Cloner> cache = new WeakHashMap<ClassManager, Cloner>();

    ClonerFactory() {
    }

    static Cloner build(VirtualMachine vm) {
        ClassManager classManager = vm.getClassManager();
        Cloner cloner = cache.get(classManager);
        if (cloner != null) {
            return cloner;
        }
        Set<String> immutableClasses = vm.getConfiguration().getImmutableClasses();
        SmaliClassLoader classLoader = vm.getClassLoader();
        cloner = new Cloner(new ObjenesisInstantiationStrategy());
        for (String immutableClass : immutableClasses) {
            Class<?> klazz;
            if (immutableClass.length() <= 1 || immutableClass.contains("$") || immutableClass.startsWith("Ljava/")) continue;
            String binaryName = ClassNameUtils.internalToBinary(immutableClass);
            try {
                klazz = classLoader.loadClass(binaryName);
            }
            catch (ClassNotFoundException e) {
                if (!log.isErrorEnabled()) continue;
                log.error("Unable to load immutable class (not found): {}", (Object)immutableClass);
                continue;
            }
            cloner.dontClone(klazz);
        }
        cache.put(classManager, cloner);
        return cloner;
    }
}

